/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree.YQL;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.parser.yqlplus.TokenSource;
import ai.vespa.schemals.tree.Node;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class YQLUtils {
    private static Position getPositionFromOffset(TokenSource tokenSource, int offset) {
        int line = tokenSource.getLineFromOffset(offset) - 1;
        int startOfLineOffset = tokenSource.getLineStartOffset(line + 1);
        int column = offset - startOfLineOffset;
        return new Position(line, column);
    }

    public static Range getRangeFromOffsets(TokenSource tokenSource, int beginOffset, int endOffset) {
        Position begin = YQLUtils.getPositionFromOffset(tokenSource, beginOffset);
        Position end = YQLUtils.getPositionFromOffset(tokenSource, endOffset);
        return new Range(begin, end);
    }

    public static Range getNodeRange(ai.vespa.schemals.parser.yqlplus.Node node) {
        TokenSource tokenSource = node.getTokenSource();
        return YQLUtils.getRangeFromOffsets(tokenSource, node.getBeginOffset(), node.getEndOffset());
    }

    public static void printTree(ClientLogger logger, ai.vespa.schemals.parser.yqlplus.Node node) {
        YQLUtils.printTree(logger, node, (Integer)0);
    }

    public static void printTree(ClientLogger logger, ai.vespa.schemals.parser.yqlplus.Node node, Integer indent) {
        Range range = YQLUtils.getNodeRange(node);
        logger.info(new String(new char[indent.intValue()]).replace("\u0000", "\t") + node.getClass().getName() + ": (" + range.getStart().getLine() + ", " + range.getStart().getCharacter() + ") - (" + range.getEnd().getLine() + ", " + range.getEnd().getCharacter() + ")");
        for (ai.vespa.schemals.parser.yqlplus.Node child : node) {
            YQLUtils.printTree(logger, child, (Integer)(indent + 1));
        }
    }

    public static void printTree(ClientLogger logger, Node node) {
        YQLUtils.printTree(logger, node, 0);
    }

    public static void printTree(ClientLogger logger, Node node, int indent) {
        String padding = new String(new char[indent]).replace("\u0000", " ");
        logger.info(padding + node.toString());
        for (Node child : node) {
            YQLUtils.printTree(logger, child, indent + 1);
        }
    }
}

