/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.FieldIndex;
import ai.vespa.schemals.index.InheritanceGraph;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.REFERENCE;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.featureListElm;
import ai.vespa.schemals.parser.ast.importField;
import ai.vespa.schemals.parser.ast.mapDataType;
import ai.vespa.schemals.parser.indexinglanguage.ast.DOT;
import ai.vespa.schemals.parser.rankingexpression.ast.BaseNode;
import ai.vespa.schemals.parser.rankingexpression.ast.args;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.BuiltInFunctions;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.FunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class SymbolReferenceResolver {
    public static void resolveSymbolReference(SchemaNode node, ParseContext context, List<Diagnostic> diagnostics) {
        Optional<Object> referencedSymbol = Optional.empty();
        Symbol.SymbolType referencedType = node.getSymbol().getType();
        if (referencedType == Symbol.SymbolType.SUBFIELD) {
            Optional<Object> parentFieldDefinition = Optional.empty();
            if (node.getLanguageType() == Node.LanguageType.RANK_EXPRESSION) {
                Node outNode = node.getParent();
                Node parentNode = outNode.getParent();
                int outNodeIndex = parentNode.indexOf(outNode);
                if (outNodeIndex == 0) {
                    Node fieldDefinitionNode = parentNode.getSibling(-2);
                    if (fieldDefinitionNode != null && fieldDefinitionNode.hasSymbol()) {
                        parentFieldDefinition = context.schemaIndex().getSymbolDefinition(fieldDefinitionNode.getSymbol());
                    }
                } else {
                    Node previousOutNode = parentNode.get(outNodeIndex - 2);
                    if (previousOutNode != null && previousOutNode.size() > 0 && previousOutNode.get(0).hasSymbol()) {
                        parentFieldDefinition = context.schemaIndex().getSymbolDefinition(previousOutNode.get(0).getSymbol());
                    }
                }
            } else {
                Node parentField = node.getPreviousSibling();
                if (parentField.getASTClass() == DOT.class) {
                    parentField = parentField.getPreviousSibling();
                }
                if (parentField.hasSymbol() && parentField.getSymbol().getStatus() == Symbol.SymbolStatus.REFERENCE) {
                    parentFieldDefinition = context.schemaIndex().getSymbolDefinition(parentField.getSymbol());
                }
            }
            if (parentFieldDefinition.isPresent()) {
                referencedSymbol = SymbolReferenceResolver.resolveSubFieldReference(node, (Symbol)parentFieldDefinition.get(), context, diagnostics);
            }
        } else if (referencedType == Symbol.SymbolType.FUNCTION) {
            referencedSymbol = context.schemaIndex().findSymbol(node.getSymbol().getScope(), Symbol.SymbolType.FUNCTION, node.getSymbol().getShortIdentifier());
            if (referencedSymbol.isEmpty()) {
                SchemaNode parent = node.getParent().getSchemaNode();
                if (parent.getOriginalRankExpressionNode() instanceof BaseNode && ((BaseNode)parent.getOriginalRankExpressionNode()).expressionNode instanceof FunctionNode) {
                    node.setSymbolStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
                    return;
                }
                if (BuiltInFunctions.simpleBuiltInFunctionsSet.contains(node.getSymbol().getShortIdentifier())) {
                    node.setSymbolStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
                    return;
                }
            }
        } else if (referencedType == Symbol.SymbolType.TYPE_UNKNOWN) {
            Symbol.SymbolType[] possibleTypes;
            if (SymbolReferenceResolver.didExpectLabel(node, diagnostics)) {
                node.setSymbolType(Symbol.SymbolType.LABEL);
                node.setSymbolStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
                return;
            }
            for (Symbol.SymbolType type : possibleTypes = new Symbol.SymbolType[]{Symbol.SymbolType.PARAMETER, Symbol.SymbolType.FUNCTION, Symbol.SymbolType.RANK_CONSTANT, Symbol.SymbolType.FIELD}) {
                referencedSymbol = context.schemaIndex().findSymbol(node.getSymbol().getScope(), type, node.getSymbol().getShortIdentifier());
                if (!referencedSymbol.isPresent()) continue;
                node.setSymbolType(type);
                break;
            }
            if (referencedSymbol.isEmpty() && BuiltInFunctions.simpleBuiltInFunctionsSet.contains(node.getSymbol().getShortIdentifier())) {
                node.setSymbolType(Symbol.SymbolType.FUNCTION);
                node.setSymbolStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
                return;
            }
        } else if (referencedType == Symbol.SymbolType.RANK_PROFILE && node.getParent().getASTClass() == featureListElm.class && node.getSymbol().getScope() != null && node.getSymbol().getScope().getType() == Symbol.SymbolType.RANK_PROFILE) {
            InheritanceGraph<Symbol> rankProfileGraph = context.schemaIndex().getRankProfileInheritanceGraph();
            String myIdentifier = node.getSymbol().getShortIdentifier();
            Symbol myRankProfileDefinitionSymbol = node.getSymbol().getScope();
            List<Symbol> result = rankProfileGraph.getAllParents(myRankProfileDefinitionSymbol).stream().filter(symbol -> symbol.getShortIdentifier().equals(myIdentifier)).toList();
            if (!result.isEmpty()) {
                if (result.size() > 1) {
                    diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(myIdentifier + " is ambiguous in this context").setSeverity(DiagnosticSeverity.Warning).build());
                }
                referencedSymbol = Optional.of(result.get(0));
            } else {
                referencedSymbol = context.schemaIndex().findSymbol(node.getSymbol());
                if (referencedSymbol.isPresent()) {
                    node.getSymbol().setStatus(Symbol.SymbolStatus.INVALID);
                    String constructType = node.getPreviousSibling().getPreviousSibling().getText();
                    diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("This can only inherit the " + constructType + " of a directly inherited profile.").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.FEATURES_INHERITS_NON_PARENT).build());
                }
            }
        } else {
            referencedSymbol = context.schemaIndex().findSymbol(node.getSymbol());
        }
        if (node.getLanguageType() == Node.LanguageType.RANK_EXPRESSION && referencedSymbol.isEmpty()) {
            referencedSymbol = context.schemaIndex().findSymbol(node.getSymbol(), Symbol.SymbolType.PARAMETER, node.getSymbol().getShortIdentifier());
        }
        if (referencedSymbol.isPresent()) {
            node.setSymbolStatus(Symbol.SymbolStatus.REFERENCE);
            context.schemaIndex().insertSymbolReference((Symbol)referencedSymbol.get(), node.getSymbol());
        } else if (referencedType != Symbol.SymbolType.QUERY_INPUT) {
            context.schemaIndex().addUnresolvedSymbol(node.getSymbol());
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Undefined symbol " + node.getText()).setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.UNDEFINED_SYMBOL).build());
        }
    }

    public static Optional<Symbol> resolveSubFieldReference(SchemaNode node, Symbol fieldDefinition, ParseContext context, List<Diagnostic> diagnostics) {
        Optional<Symbol> structFieldDefinition2;
        if (fieldDefinition.getType() != Symbol.SymbolType.FIELD && fieldDefinition.getType() != Symbol.SymbolType.MAP_VALUE && fieldDefinition.getType() != Symbol.SymbolType.STRUCT) {
            return Optional.empty();
        }
        if (fieldDefinition.getStatus() != Symbol.SymbolStatus.DEFINITION) {
            return Optional.empty();
        }
        if (fieldDefinition.getType() == Symbol.SymbolType.STRUCT) {
            return SymbolReferenceResolver.resolveFieldInStructReference(node, fieldDefinition, context);
        }
        if (fieldDefinition.getType() == Symbol.SymbolType.FIELD && (structFieldDefinition2 = context.schemaIndex().findSymbolInScope(fieldDefinition, Symbol.SymbolType.FIELD, node.getText())).isPresent()) {
            node.setSymbolType(Symbol.SymbolType.FIELD);
            return structFieldDefinition2;
        }
        SchemaNode dataTypeNode = null;
        Optional<Symbol> referencedSymbol = Optional.empty();
        if (fieldDefinition.getType() == Symbol.SymbolType.MAP_VALUE) {
            dataTypeNode = fieldDefinition.getNode().getSchemaNode();
        } else if (fieldDefinition.getType() == Symbol.SymbolType.FIELD) {
            if (fieldDefinition.getNode().getNextSibling() == null || fieldDefinition.getNode().getNextSibling().getNextSibling() == null) {
                return Optional.empty();
            }
            dataTypeNode = fieldDefinition.getNode().getNextSibling().getNextSibling().getSchemaNode();
            if (dataTypeNode.getASTClass() != dataType.class) {
                return Optional.empty();
            }
            if (dataTypeNode.hasSymbol()) {
                if (!SymbolReferenceResolver.isStructReference(dataTypeNode)) {
                    return Optional.empty();
                }
                Symbol structReference = dataTypeNode.getSymbol();
                Symbol structDefinition = context.schemaIndex().getSymbolDefinition(structReference).get();
                return SymbolReferenceResolver.resolveFieldInStructReference(node, structDefinition, context);
            }
            if (dataTypeNode.get(0).getASTClass() == REFERENCE.class) {
                if (dataTypeNode.size() < 3 || !dataTypeNode.get(2).get(0).hasSymbol()) {
                    return Optional.empty();
                }
                Symbol documentReference = dataTypeNode.get(2).get(0).getSymbol();
                Optional<Object> documentDefinition = Optional.empty();
                documentDefinition = documentReference.getStatus() == Symbol.SymbolStatus.REFERENCE ? context.schemaIndex().getSymbolDefinition(documentReference) : context.schemaIndex().findSymbol(documentReference);
                if (documentDefinition.isEmpty()) {
                    return Optional.empty();
                }
                referencedSymbol = context.schemaIndex().findSymbol((Symbol)documentDefinition.get(), Symbol.SymbolType.FIELD, node.getText());
                if (referencedSymbol.isPresent()) {
                    node.setSymbolType(referencedSymbol.get().getType());
                    EnumSet<FieldIndex.IndexingType> referencedSymbolIndexingTypes = context.fieldIndex().getFieldIndexingTypes(referencedSymbol.get());
                    if (node.getParent().getASTClass() != importField.class) {
                        diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Field " + referencedSymbol.get().getLongIdentifier() + " can not be accessed directly. Hint: Add an import field statement to access the field.").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.ACCESS_UNIMPORTED_FIELD).build());
                        return referencedSymbol;
                    }
                    if (!referencedSymbolIndexingTypes.contains((Object)FieldIndex.IndexingType.ATTRIBUTE)) {
                        diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Cannot import " + referencedSymbol.get().getLongIdentifier() + " because it is not an attribute field. Only attribute fields can be imported.").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.IMPORT_FIELD_ATTRIBUTE).build());
                    } else if (referencedSymbolIndexingTypes.contains((Object)FieldIndex.IndexingType.INDEX)) {
                        diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Cannot import " + referencedSymbol.get().getLongIdentifier() + " because it is an index field. Importing index fields is not supported.").setSeverity(DiagnosticSeverity.Error).build());
                    }
                    Symbol importFieldDefinitionSymbol = node.getNextSibling().getNextSibling().getSymbol();
                    if (importFieldDefinitionSymbol != null && importFieldDefinitionSymbol.getStatus() == Symbol.SymbolStatus.DEFINITION) {
                        for (FieldIndex.IndexingType indexingType : referencedSymbolIndexingTypes) {
                            context.fieldIndex().addFieldIndexingType(importFieldDefinitionSymbol, indexingType);
                        }
                    }
                }
                return referencedSymbol;
            }
        } else {
            return Optional.empty();
        }
        dataType originalNode = (dataType)dataTypeNode.getOriginalSchemaNode();
        if (originalNode.getParsedType().getVariant() == ParsedType.Variant.MAP) {
            return SymbolReferenceResolver.resolveMapValueReference(node, fieldDefinition, context);
        }
        if (originalNode.getParsedType().getVariant() == ParsedType.Variant.ARRAY) {
            if (dataTypeNode.size() < 3 || dataTypeNode.get(2).getASTClass() != dataType.class) {
                return Optional.empty();
            }
            Node innerType = dataTypeNode.get(2);
            if (!SymbolReferenceResolver.isStructReference(innerType)) {
                return Optional.empty();
            }
            Symbol structReference = innerType.getSymbol();
            Symbol structDefinition = context.schemaIndex().getSymbolDefinition(structReference).get();
            return SymbolReferenceResolver.resolveFieldInStructReference(node, structDefinition, context);
        }
        return referencedSymbol;
    }

    private static Optional<Symbol> resolveFieldInStructReference(SchemaNode node, Symbol structDefinition, ParseContext context) {
        Optional<Symbol> referencedSymbol = context.schemaIndex().findSymbol(structDefinition, Symbol.SymbolType.FIELD, node.getText());
        if (referencedSymbol.isPresent()) {
            if (!context.schemaIndex().isInScope(referencedSymbol.get(), structDefinition)) {
                return Optional.empty();
            }
            node.setSymbolType(referencedSymbol.get().getType());
        }
        return referencedSymbol;
    }

    private static Optional<Symbol> resolveMapValueReference(SchemaNode node, Symbol mapValueDefinition, ParseContext context) {
        Optional<Symbol> referencedSymbol = Optional.empty();
        if (node.getText().equals("key")) {
            referencedSymbol = context.schemaIndex().findSymbol(mapValueDefinition, Symbol.SymbolType.MAP_KEY, "key");
            referencedSymbol.ifPresent(symbol -> node.setSymbolType(Symbol.SymbolType.MAP_KEY));
        }
        if (node.getText().equals("value")) {
            referencedSymbol = SymbolReferenceResolver.findMapValueDefinition(context, mapValueDefinition);
            referencedSymbol.ifPresent(symbol -> node.setSymbolType(symbol.getType()));
        }
        return referencedSymbol;
    }

    private static boolean isStructReference(Node node) {
        return node != null && node.hasSymbol() && node.getSymbol().getType() == Symbol.SymbolType.STRUCT && node.getSymbol().getStatus() == Symbol.SymbolStatus.REFERENCE;
    }

    private static Optional<Symbol> findMapValueDefinition(ParseContext context, Symbol fieldDefinition) {
        if (fieldDefinition.getType() != Symbol.SymbolType.FIELD) {
            return Optional.empty();
        }
        Node dataTypeNode = fieldDefinition.getNode().getNextSibling().getNextSibling();
        if (dataTypeNode == null || dataTypeNode.getASTClass() != dataType.class) {
            return Optional.empty();
        }
        if (dataTypeNode.size() == 0 || dataTypeNode.get(0).getASTClass() != mapDataType.class) {
            return Optional.empty();
        }
        Node valueNode = dataTypeNode.get(0).get(4);
        if (!valueNode.hasSymbol()) {
            return Optional.empty();
        }
        switch (valueNode.getSymbol().getStatus()) {
            case DEFINITION: {
                return Optional.of(valueNode.getSymbol());
            }
            case REFERENCE: {
                return context.schemaIndex().getSymbolDefinition(valueNode.getSymbol());
            }
        }
        return Optional.empty();
    }

    private static boolean didExpectLabel(SchemaNode node, List<Diagnostic> diagnostics) {
        Node argsNode;
        SchemaNode argsChild = node;
        for (argsNode = node.getParent(); argsNode != null && argsNode.getASTClass() != args.class; argsNode = argsNode.getParent()) {
            argsChild = argsNode.getSchemaNode();
        }
        if (argsNode == null) {
            return false;
        }
        Node identifierNode = argsNode.getParent().get(0);
        SchemaNode containingFeature = argsNode.getParent().getSchemaNode();
        ReferenceNode functionExpressionNode = (ReferenceNode)((BaseNode)containingFeature.getOriginalRankExpressionNode()).expressionNode;
        ExpressionNode myArg = ((BaseNode)argsChild.getOriginalRankExpressionNode()).expressionNode;
        int myArgIndex = functionExpressionNode.children().indexOf(myArg);
        if (!identifierNode.hasSymbol() || identifierNode.getSymbol().getStatus() != Symbol.SymbolStatus.BUILTIN_REFERENCE) {
            return false;
        }
        String functionIdentifier = identifierNode.getSymbol().getShortIdentifier();
        if (functionIdentifier.equals("itemRawScore")) {
            return true;
        }
        if (functionIdentifier.equals("closest")) {
            return myArgIndex == 1;
        }
        if (functionIdentifier.equals("distance") || functionIdentifier.equals("closeness")) {
            switch (myArgIndex) {
                case 0: {
                    return node.getSymbol().getShortIdentifier().equals("label") || node.getSymbol().getShortIdentifier().equals("field");
                }
                case 1: {
                    ExpressionNode firstArg = (ExpressionNode)functionExpressionNode.children().get(0);
                    return firstArg instanceof ReferenceNode && ((ReferenceNode)firstArg).getName().equals("label");
                }
            }
            return false;
        }
        if (functionIdentifier.equals("tensorFromWeightedSet") || functionIdentifier.equals("tensorFromLabels")) {
            return myArgIndex == 1;
        }
        if (functionIdentifier.equals("query")) {
            return myArgIndex == 0;
        }
        return false;
    }
}

