/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.semantictokens;

import ai.vespa.schemals.lsp.common.semantictokens.CommonSemanticTokens;
import ai.vespa.schemals.tree.Node;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Range;

public class SemanticTokenMarker {
    private static final int LINE_INDEX = 0;
    private static final int COLUMN_INDEX = 1;
    private int tokenType;
    private int modifierValue = 0;
    private Range range;

    public SemanticTokenMarker(int tokenType, Node node) {
        this(tokenType, node.getRange());
    }

    public SemanticTokenMarker(int tokenType, Range range) {
        this.tokenType = tokenType;
        this.range = range;
    }

    public Range getRange() {
        return this.range;
    }

    public void addModifier(String modifier) {
        int modifierIndex = CommonSemanticTokens.getModifier(modifier);
        if (modifierIndex == -1) {
            throw new IllegalArgumentException("Could not find the semantic token modifier '" + modifier + "'. Remember to add the modifier to the tokenModifiers list.");
        }
        int bitMask = 1 << modifierIndex;
        this.modifierValue |= bitMask;
    }

    private ArrayList<Integer> compactForm() {
        final int length = this.range.getEnd().getCharacter() - this.range.getStart().getCharacter();
        return new ArrayList<Integer>(){
            {
                this.add(SemanticTokenMarker.this.range.getStart().getLine());
                this.add(SemanticTokenMarker.this.range.getStart().getCharacter());
                this.add(length);
                this.add(SemanticTokenMarker.this.tokenType);
                this.add(SemanticTokenMarker.this.modifierValue);
            }
        };
    }

    public static List<Integer> concatCompactForm(List<SemanticTokenMarker> markers) {
        ArrayList<Integer> ret = new ArrayList<Integer>(markers.size() * 5);
        if (markers.size() == 0) {
            return ret;
        }
        ret.addAll(markers.get(0).compactForm());
        for (int i = 1; i < markers.size(); ++i) {
            ArrayList<Integer> markerCompact = markers.get(i).compactForm();
            ArrayList<Integer> lastMarkerCompact = markers.get(i - 1).compactForm();
            markerCompact.set(0, markerCompact.get(0) - lastMarkerCompact.get(0));
            if (markerCompact.get(0) == 0) {
                markerCompact.set(1, markerCompact.get(1) - lastMarkerCompact.get(1));
            }
            ret.addAll(markerCompact);
        }
        return ret;
    }
}

