/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression;

import ai.vespa.schemals.schemadocument.resolvers.RankExpression.FunctionSignature;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.GenericFunction;
import java.util.Optional;

public class SpecificFunction {
    GenericFunction function;
    FunctionSignature signature;
    Optional<String> property;

    public SpecificFunction(GenericFunction function2, FunctionSignature signature, Optional<String> property) {
        this.function = function2;
        this.signature = signature;
        this.property = property;
    }

    public SpecificFunction(GenericFunction function2, FunctionSignature signature) {
        this(function2, signature, Optional.empty());
    }

    public String getSignatureString(boolean altSignature) {
        String signatureString = this.signature.toString();
        if (altSignature && this.property.isEmpty() && signatureString.equals("()")) {
            return this.function.getName();
        }
        return this.function.getName() + signatureString + (String)(this.property.isPresent() ? "." + this.property.get() : "");
    }

    public String getSignatureString() {
        return this.getSignatureString(false);
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    public void setProperty(String property) {
        this.property = Optional.of(property);
    }

    public void clearProperty() {
        this.property = Optional.empty();
    }

    public SpecificFunction clone() {
        return new SpecificFunction(this.function, this.signature, this.property);
    }
}

