/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.completion.provider;

import ai.vespa.schemals.common.LocaleList;
import ai.vespa.schemals.lsp.common.completion.CompletionUtils;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.ast.attributeElm;
import ai.vespa.schemals.parser.ast.attributeSetting;
import ai.vespa.schemals.parser.ast.dictionarySetting;
import ai.vespa.schemals.parser.ast.fieldRankFilter;
import ai.vespa.schemals.parser.ast.fieldStemming;
import ai.vespa.schemals.parser.ast.hnswIndex;
import ai.vespa.schemals.parser.ast.indexInsideField;
import ai.vespa.schemals.parser.ast.matchSettingsElm;
import ai.vespa.schemals.parser.ast.normalizingElm;
import ai.vespa.schemals.parser.ast.rankElm;
import ai.vespa.schemals.parser.ast.rankTypeElm;
import ai.vespa.schemals.parser.ast.sortingElm;
import ai.vespa.schemals.parser.ast.sortingSetting;
import ai.vespa.schemals.parser.ast.strictElm;
import ai.vespa.schemals.parser.ast.summaryInField;
import ai.vespa.schemals.parser.ast.weakandElm;
import ai.vespa.schemals.parser.ast.weightedsetElm;
import java.util.List;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public class FixedKeywordBodies {
    public static FixedKeywordBody MATCH = new FixedKeywordBody("match", Token.TokenType.MATCH, matchSettingsElm.class, List.of(CompletionUtils.constructBasic("text"), CompletionUtils.constructBasic("word"), CompletionUtils.constructBasic("exact"), CompletionUtils.constructBasic("gram"), CompletionUtils.constructBasic("cased"), CompletionUtils.constructBasic("uncased"), CompletionUtils.constructBasic("prefix"), CompletionUtils.constructBasic("substring"), CompletionUtils.constructBasic("suffix")));
    public static FixedKeywordBody RANK = new FixedKeywordBody("rank", Token.TokenType.RANK, rankElm.class, List.of(CompletionUtils.constructBasic("filter"), CompletionUtils.constructBasic("literal"), CompletionUtils.constructBasic("normal")));
    public static FixedKeywordBody RANK_IN_PROFILE = new FixedKeywordBody("rank", Token.TokenType.RANK, fieldRankFilter.class, List.of(CompletionUtils.constructSnippet("filter-threshold", "filter-threshold: ")));
    public static FixedKeywordBody STRICT = new FixedKeywordBody("strict", Token.TokenType.STRICT, strictElm.class, List.of(CompletionUtils.constructBasic("true"), CompletionUtils.constructBasic("false")));
    public static FixedKeywordBody RANK_TYPE = new FixedKeywordBody("rank-type", Token.TokenType.RANK_TYPE, rankTypeElm.class, List.of(CompletionUtils.constructBasic("identity"), CompletionUtils.constructBasic("about"), CompletionUtils.constructBasic("tags"), CompletionUtils.constructBasic("empty")));
    public static FixedKeywordBody SUMMARY = new FixedKeywordBody("summary", Token.TokenType.SUMMARY, summaryInField.class, List.of(CompletionUtils.constructBasic("full"), CompletionUtils.constructSnippet("bolding", "bolding: ${1|on,off|}"), CompletionUtils.constructBasic("dynamic"), CompletionUtils.constructSnippet("source", "source: "), CompletionUtils.constructSnippet("to", "to: "), CompletionUtils.constructBasic("matched-elements-only"), CompletionUtils.constructBasic("tokens")));
    public static FixedKeywordBody WEIGHTEDSET = new FixedKeywordBody("weightedset", Token.TokenType.WEIGHTEDSET, weightedsetElm.class, List.of(CompletionUtils.constructBasic("create-if-nonexistent"), CompletionUtils.constructBasic("remove-if-zero")));
    public static FixedKeywordBody HNSW = new FixedKeywordBody("hnsw", Token.TokenType.HNSW, hnswIndex.class, List.of(CompletionUtils.constructSnippet("max-links-per-node", "max-links-per-node: "), CompletionUtils.constructSnippet("neighbors-to-explore-at-insert", "neighbors-to-explore-at-insert: ")));
    public static FixedKeywordBody STEMMING = new FixedKeywordBody("stemming", Token.TokenType.STEMMING, fieldStemming.class, List.of(CompletionUtils.constructBasic("none"), CompletionUtils.constructBasic("best"), CompletionUtils.constructBasic("shortest"), CompletionUtils.constructBasic("multiple")));
    public static FixedKeywordBody NORMALIZING = new FixedKeywordBody("normalizing", Token.TokenType.NORMALIZING, normalizingElm.class, List.of(CompletionUtils.constructBasic("none")));
    public static FixedKeywordBody DICTIONARY = new FixedKeywordBody("dictionary", Token.TokenType.DICTIONARY, dictionarySetting.class, List.of(CompletionUtils.constructBasic("btree"), CompletionUtils.constructBasic("hash"), CompletionUtils.constructBasic("cased"), CompletionUtils.constructBasic("uncased")));
    public static FixedKeywordBody SORT_FUNCTION = new FixedKeywordBody("function", Token.TokenType.FUNCTION, sortingSetting.class, List.of(CompletionUtils.constructBasic("uca"), CompletionUtils.constructBasic("lowercase"), CompletionUtils.constructBasic("raw")));
    public static FixedKeywordBody SORT_STRENGTH = new FixedKeywordBody("strength", Token.TokenType.STRENGTH, sortingSetting.class, List.of(CompletionUtils.constructBasic("primary"), CompletionUtils.constructBasic("secondary"), CompletionUtils.constructBasic("tertiary"), CompletionUtils.constructBasic("quaternary"), CompletionUtils.constructBasic("identical")));
    public static FixedKeywordBody SORT_LOCALE = new FixedKeywordBody("locale", Token.TokenType.LOCALE, sortingSetting.class, LocaleList.locales.stream().map(locale -> CompletionUtils.constructBasic(locale)).toList());
    public static FixedKeywordBody SORTING = new FixedKeywordBody("sorting", Token.TokenType.SORTING, sortingElm.class, List.of(CompletionUtils.constructBasic("ascending"), CompletionUtils.constructBasic("descending"), SORT_FUNCTION.getColonSnippet(), SORT_STRENGTH.getColonSnippet(), SORT_LOCALE.getColonSnippet()));
    public static FixedKeywordBody DISTANCE_METRIC = new FixedKeywordBody("distance-metric", Token.TokenType.DISTANCE_METRIC, attributeSetting.class, List.of(CompletionUtils.constructBasic("euclidean"), CompletionUtils.constructBasic("angular"), CompletionUtils.constructBasic("dotproduct"), CompletionUtils.constructBasic("prenormalized-angular"), CompletionUtils.constructBasic("geodegrees"), CompletionUtils.constructBasic("hamming")));
    public static FixedKeywordBody ATTRIBUTE = new FixedKeywordBody("attribute", Token.TokenType.ATTRIBUTE, attributeElm.class, List.of(CompletionUtils.constructBasic("fast-search"), CompletionUtils.constructBasic("fast-access"), CompletionUtils.constructBasic("fast-rank"), CompletionUtils.constructBasic("paged"), SORTING.getColonSnippet(), SORTING.getBodySnippet(), DISTANCE_METRIC.getColonSnippet(), CompletionUtils.constructBasic("mutable")));
    public static FixedKeywordBody INDEX = new FixedKeywordBody("index", Token.TokenType.INDEX, indexInsideField.class, List.of(STEMMING.getColonSnippet(), CompletionUtils.constructSnippet("arity", "arity: "), CompletionUtils.constructSnippet("lower-bound", "lower-bound: "), CompletionUtils.constructSnippet("upper-bound", "upper-bound: "), CompletionUtils.constructSnippet("dense-posting-list-threshold", "dense-posting-list-threshold: "), CompletionUtils.constructBasic("enable-bm25"), HNSW.getBodySnippet()));
    public static FixedKeywordBody WEAKAND = new FixedKeywordBody("weakand", Token.TokenType.WEAKAND, weakandElm.class, List.of(CompletionUtils.constructSnippet("stopword-limit", "stopword-limit: "), CompletionUtils.constructSnippet("adjust-target", "adjust-target: ")));

    public record FixedKeywordBody(String name, Token.TokenType tokenType, Class<? extends Node> parentASTClass, List<CompletionItem> completionItems) {
        public String getChoiceTemplate(boolean excludeSnippets) {
            return String.join((CharSequence)",", this.completionItems.stream().filter(item -> !excludeSnippets || item.getKind() != CompletionItemKind.Snippet).map(item -> item.getLabel()).toList());
        }

        public boolean hasSnippets() {
            return this.completionItems.stream().filter(item -> item.getKind() == CompletionItemKind.Snippet).count() > 0L;
        }

        public String getChoiceTemplate() {
            return this.getChoiceTemplate(false);
        }

        public CompletionItem getColonSnippet(boolean hasAdditionalSpec) {
            String snippetContent = this.name + (hasAdditionalSpec ? " $1: " : ": ");
            if (!this.hasSnippets()) {
                snippetContent = snippetContent + "${" + (hasAdditionalSpec ? "2|" : "1|") + this.getChoiceTemplate() + "|}";
            }
            return CompletionUtils.constructSnippet(this.name, snippetContent, this.name + ":");
        }

        public CompletionItem getColonSnippet() {
            return this.getColonSnippet(false);
        }

        public CompletionItem getBodySnippet(boolean hasAdditionalSpec) {
            String snippetContent = this.name + (hasAdditionalSpec ? " $1 {\n\t" : " {\n\t");
            if (!this.hasSnippets()) {
                snippetContent = snippetContent + "${" + (hasAdditionalSpec ? "2|" : "1|") + this.getChoiceTemplate() + "|}";
            }
            snippetContent = snippetContent + "$0\n";
            snippetContent = snippetContent + "}";
            return CompletionUtils.constructSnippet(this.name, snippetContent, this.name + " {}");
        }

        public CompletionItem getBodySnippet() {
            return this.getBodySnippet(false);
        }
    }
}

