/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.index;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.tree.Node;
import java.net.URI;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;

public class Symbol {
    private Node identifierNode;
    private Symbol scope = null;
    private String fileURI;
    private URI fileURIimpl;
    private SymbolType type;
    private SymbolStatus status;
    private String overrideShortIdentifier = null;

    public Symbol(Node identifierNode, SymbolType type, String fileURI, Symbol scope, String shortIdentifier) {
        this.identifierNode = identifierNode;
        this.setFileURI(fileURI);
        this.type = type;
        this.status = SymbolStatus.UNRESOLVED;
        this.scope = scope;
        this.overrideShortIdentifier = shortIdentifier;
    }

    public Symbol(Node identifierNode, SymbolType type, String fileURI) {
        this(identifierNode, type, fileURI, null, null);
    }

    public Symbol(Node identifierNode, SymbolType type, String fileURI, Symbol scope) {
        this(identifierNode, type, fileURI, scope, null);
    }

    public String getFileURI() {
        return this.fileURI;
    }

    public String setFileURI(String fileURI) {
        this.fileURI = fileURI;
        this.fileURIimpl = URI.create(fileURI);
        return fileURI;
    }

    public boolean fileURIEquals(Symbol other) {
        return this.fileURIimpl.equals(other.fileURIimpl);
    }

    public boolean fileURIEquals(String otherURI) {
        return this.fileURIimpl.equals(URI.create(otherURI));
    }

    public boolean fileURIEquals(URI otherURI) {
        return this.fileURIimpl.equals(otherURI);
    }

    public void setType(SymbolType type) {
        this.type = type;
    }

    public SymbolType getType() {
        return this.type;
    }

    public void setStatus(SymbolStatus status) {
        this.status = status;
    }

    public SymbolStatus getStatus() {
        return this.status;
    }

    public Symbol getScope() {
        return this.scope;
    }

    public void setScope(Symbol scope) {
        this.scope = scope;
    }

    public boolean isInScope(Symbol scope) {
        if (scope == null || this.scope == null) {
            return false;
        }
        return this.scope.equals(scope);
    }

    public Node getNode() {
        return this.identifierNode;
    }

    public String getShortIdentifier() {
        if (this.overrideShortIdentifier != null) {
            return this.overrideShortIdentifier;
        }
        return this.identifierNode.getText();
    }

    public String getLongIdentifier() {
        if (this.scope == null) {
            return this.getShortIdentifier();
        }
        return this.scope.getLongIdentifier() + "." + this.getShortIdentifier();
    }

    public String getPrettyIdentifier() {
        if (this.type == SymbolType.DOCUMENT || this.type == SymbolType.SCHEMA) {
            return this.getShortIdentifier();
        }
        if (this.scope == null || this.scope.getType() == SymbolType.DOCUMENT || this.scope.getType() == SymbolType.SCHEMA) {
            return this.getShortIdentifier();
        }
        return this.scope.getPrettyIdentifier() + "." + this.getShortIdentifier();
    }

    public Location getLocation() {
        return new Location(this.fileURI, this.identifierNode.getRange());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol other = (Symbol)obj;
        return this.fileURIEquals(other) && this.type == other.type && this.status == other.status && this.getNode() != null && other.getNode() != null && this.getNode().getRange() != null && other.getNode().getRange() != null && this.getNode().getRange().equals((Object)other.getNode().getRange());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileURI == null ? 0 : this.fileURIimpl.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.getNode() == null || this.getNode().getRange() == null ? 0 : this.getNode().getRange().hashCode());
        return result;
    }

    public String toString() {
        Position pos = this.getNode().getRange().getStart();
        String fileName = FileUtils.fileNameFromPath(this.fileURI);
        return "Symbol('" + this.getLongIdentifier() + "', " + String.valueOf((Object)this.getType()) + ", " + String.valueOf((Object)this.getStatus()) + ", at: " + fileName + ":" + pos.getLine() + ":" + pos.getCharacter() + ")@" + System.identityHashCode(this);
    }

    public static enum SymbolType {
        ANNOTATION,
        DOCUMENT,
        DOCUMENT_SUMMARY,
        FIELD,
        FIELDSET,
        FUNCTION,
        LABEL,
        LAMBDA_FUNCTION,
        MAP_KEY,
        MAP_VALUE,
        ONNX_MODEL,
        PARAMETER,
        PROPERTY,
        QUERY_INPUT,
        RANK_CONSTANT,
        RANK_PROFILE,
        RANK_TYPE,
        SCHEMA,
        STRUCT,
        STRUCT_FIELD,
        SUBFIELD,
        TENSOR,
        TENSOR_DIMENSION_INDEXED,
        TENSOR_DIMENSION_MAPPED,
        TYPE_UNKNOWN,
        DIMENSION;

    }

    public static enum SymbolStatus {
        DEFINITION,
        REFERENCE,
        UNRESOLVED,
        INVALID,
        BUILTIN_REFERENCE;

    }
}

