/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.ast.EXPRESSION_SL;
import ai.vespa.schemals.parser.ast.IDENTIFIER_WITH_DASH;
import ai.vespa.schemals.parser.ast.MATCHFEATURES_SL;
import ai.vespa.schemals.parser.ast.NL;
import ai.vespa.schemals.parser.ast.RANKFEATURES_SL;
import ai.vespa.schemals.parser.ast.SUMMARYFEATURES_SL;
import ai.vespa.schemals.parser.ast.identifierWithDashStr;
import ai.vespa.schemals.parser.rankingexpression.ParseException;
import ai.vespa.schemals.parser.rankingexpression.RankingExpressionParser;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class SchemaRankExpressionParser {
    private static final HashSet<Token.TokenType> multilineTokens = new HashSet<Token.TokenType>(){
        {
            this.add(Token.TokenType.EXPRESSION_ML);
            this.add(Token.TokenType.SUMMARYFEATURES_ML);
            this.add(Token.TokenType.SUMMARYFEATURES_ML_INHERITS);
            this.add(Token.TokenType.MATCHFEATURES_ML);
            this.add(Token.TokenType.MATCHFEATURES_ML_INHERITS);
            this.add(Token.TokenType.RANKFEATURES_ML);
        }
    };
    private static final HashSet<Token.TokenType> inheritsTokens = new HashSet<Token.TokenType>(){
        {
            this.add(Token.TokenType.SUMMARYFEATURES_ML_INHERITS);
            this.add(Token.TokenType.MATCHFEATURES_ML_INHERITS);
        }
    };
    private static final HashMap<Token.TokenType, String> preTextMap = new HashMap<Token.TokenType, String>(){
        {
            this.put(Token.TokenType.EXPRESSION_SL, "expression");
            this.put(Token.TokenType.EXPRESSION_ML, "expression");
            this.put(Token.TokenType.SUMMARYFEATURES_SL, "summary-features");
            this.put(Token.TokenType.SUMMARYFEATURES_ML, "summary-features");
            this.put(Token.TokenType.SUMMARYFEATURES_ML_INHERITS, "summary-features inherits");
            this.put(Token.TokenType.MATCHFEATURES_SL, "match-features");
            this.put(Token.TokenType.MATCHFEATURES_ML, "match-features");
            this.put(Token.TokenType.MATCHFEATURES_ML_INHERITS, "match-features inherits");
            this.put(Token.TokenType.RANKFEATURES_SL, "rank-features");
            this.put(Token.TokenType.RANKFEATURES_ML, "rank-features");
        }
    };
    private static final HashMap<Token.TokenType, Token.TokenType> simplifyTokenTypeMap = new HashMap<Token.TokenType, Token.TokenType>(){
        {
            this.put(Token.TokenType.EXPRESSION_SL, Token.TokenType.EXPRESSION_SL);
            this.put(Token.TokenType.EXPRESSION_ML, Token.TokenType.EXPRESSION_SL);
            this.put(Token.TokenType.SUMMARYFEATURES_SL, Token.TokenType.SUMMARYFEATURES_SL);
            this.put(Token.TokenType.SUMMARYFEATURES_ML, Token.TokenType.SUMMARYFEATURES_SL);
            this.put(Token.TokenType.SUMMARYFEATURES_ML_INHERITS, Token.TokenType.SUMMARYFEATURES_SL);
            this.put(Token.TokenType.MATCHFEATURES_SL, Token.TokenType.MATCHFEATURES_SL);
            this.put(Token.TokenType.MATCHFEATURES_ML, Token.TokenType.MATCHFEATURES_SL);
            this.put(Token.TokenType.MATCHFEATURES_ML_INHERITS, Token.TokenType.MATCHFEATURES_SL);
            this.put(Token.TokenType.RANKFEATURES_SL, Token.TokenType.RANKFEATURES_SL);
            this.put(Token.TokenType.RANKFEATURES_ML, Token.TokenType.RANKFEATURES_SL);
        }
    };
    private static final Map<Token.TokenType, Class<? extends Node>> tokenTypeToASTClass = new HashMap<Token.TokenType, Class<? extends Node>>(){
        {
            this.put(Token.TokenType.EXPRESSION_SL, EXPRESSION_SL.class);
            this.put(Token.TokenType.SUMMARYFEATURES_SL, SUMMARYFEATURES_SL.class);
            this.put(Token.TokenType.MATCHFEATURES_SL, MATCHFEATURES_SL.class);
            this.put(Token.TokenType.RANKFEATURES_SL, RANKFEATURES_SL.class);
            this.put(Token.TokenType.NL, NL.class);
        }
    };
    private static final HashSet<Character> skipCharacters = new HashSet<Character>(){
        {
            this.add(Character.valueOf(' '));
            this.add(Character.valueOf('\t'));
            this.add(Character.valueOf('\r'));
            this.add(Character.valueOf('\f'));
        }
    };

    private static ExpressionMetaData findExpressionMetaData(SchemaNode node) {
        Token.TokenType nodeType = node.findFirstLeaf().getSchemaNode().getSchemaType();
        boolean inherits = inheritsTokens.contains(nodeType);
        boolean isMultiline = multilineTokens.contains(nodeType);
        int splitChar = isMultiline ? 123 : 58;
        int offset = node.getText().indexOf(splitChar) + 1;
        String preString = node.getText().substring(0, offset);
        int numberOfNewLines = (int)preString.chars().filter(ch -> ch == 10).count();
        offset = preString.length() - preString.lastIndexOf(10) - 1;
        Position expressionOffset = new Position(numberOfNewLines, offset);
        return new ExpressionMetaData(isMultiline, inherits, expressionOffset, preString);
    }

    static void printExpressionTree(PrintStream logger, ExpressionNode node, int indent) {
        String[] classList = node.getClass().toString().split("[.]");
        String className = classList[classList.length - 1];
        String msg = node.toString() + " (" + className + ")";
        if (node instanceof ReferenceNode) {
            Reference ref = ((ReferenceNode)node).reference();
            msg = msg + " [REF: " + ref.name() + "]";
            if (ref.isIdentifier()) {
                msg = msg + " [IDENTIFIER]";
            }
            if (ref.output() != null) {
                msg = msg + " [OUTPUT: " + ref.output() + "]";
            }
        }
        logger.println(new String(new char[indent]).replaceAll("\u0000", "\t") + msg);
        if (node instanceof CompositeNode) {
            for (ExpressionNode child : ((CompositeNode)node).children()) {
                SchemaRankExpressionParser.printExpressionTree(logger, child, indent + 1);
            }
        }
    }

    static SchemaNode parseRankingExpression(ParseContext context, SchemaNode node, Position expressionOffset, List<Diagnostic> diagnostics) {
        String expressionString = node.getRankExpressionString();
        Position expressionStart = CSTUtils.addPositions(node.getRange().getStart(), expressionOffset);
        if (expressionString == null) {
            return null;
        }
        String sequence = expressionString;
        RankingExpressionParser tolerantParser = new RankingExpressionParser(context.fileURI(), sequence);
        tolerantParser.setParserTolerant(true);
        try {
            if (node.containsExpressionData()) {
                tolerantParser.expression();
            } else {
                tolerantParser.featureList();
            }
        }
        catch (ParseException parseException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (tolerantParser.rootNode() == null) {
            return null;
        }
        return new SchemaNode(tolerantParser.rootNode(), expressionStart);
    }

    private static SchemaNode tokenFromRawText(ParseContext context, SchemaNode node, Token.TokenType type, String text, Range nodeRange) {
        SchemaNode ret = new SchemaNode(nodeRange, text, type.toString().toUpperCase() + " [CUSTOM LANGUAGE]");
        ret.setSchemaType(type);
        if (tokenTypeToASTClass.containsKey(type)) {
            ret.setSimulatedASTClass(tokenTypeToASTClass.get(type));
        }
        return ret;
    }

    private static SchemaNode parseIdentifierWithDash(ParseContext context, SchemaNode node, String text, int startSearch, int endSearch) {
        int trailingSplitPos;
        int leadingSplitPos;
        String subString = text.substring(startSearch, endSearch);
        for (leadingSplitPos = 0; leadingSplitPos < subString.length() - 1 && skipCharacters.contains(Character.valueOf(subString.charAt(leadingSplitPos))); ++leadingSplitPos) {
        }
        for (trailingSplitPos = subString.length() - 1; trailingSplitPos > 0 && skipCharacters.contains(Character.valueOf(subString.charAt(trailingSplitPos - 1))); --trailingSplitPos) {
        }
        if (!skipCharacters.contains(Character.valueOf(subString.charAt(trailingSplitPos)))) {
            ++trailingSplitPos;
        }
        subString = subString.substring(leadingSplitPos, trailingSplitPos);
        int line = node.getRange().getStart().getLine();
        int character = node.getRange().getStart().getCharacter();
        Range range = new Range(new Position(line, character + startSearch + leadingSplitPos), new Position(line, character + startSearch + trailingSplitPos));
        String identifierString = Token.TokenType.IDENTIFIER_WITH_DASH.toString().toUpperCase() + " [CUSTOM LANGUAGE]";
        SchemaNode child = new SchemaNode(range, subString, identifierString);
        SchemaNode parent = new SchemaNode(range, subString, "identifierWithDashStr [CUSTOM LANGUAGE]");
        child.setSimulatedASTClass(IDENTIFIER_WITH_DASH.class);
        parent.setSimulatedASTClass(identifierWithDashStr.class);
        parent.addChild(child);
        return parent;
    }

    private static ArrayList<SchemaNode> findPreChildren(ParseContext context, ExpressionMetaData metaData, SchemaNode node) {
        ArrayList<SchemaNode> children = new ArrayList<SchemaNode>();
        Token.TokenType nodeType = node.findFirstLeaf().getSchemaNode().getSchemaType();
        String firstTokenString = preTextMap.get(nodeType);
        if (firstTokenString == null) {
            return null;
        }
        Token.TokenType simplifiedType = simplifyTokenTypeMap.get(nodeType);
        if (simplifiedType == null) {
            return null;
        }
        char searchChar = metaData.multiline() ? (char)'{' : ':';
        Token.TokenType charTokenType = metaData.multiline() ? Token.TokenType.LBRACE : Token.TokenType.COLON;
        int charPosition = metaData.preText().indexOf(searchChar, firstTokenString.length());
        if (!metaData.inherits()) {
            Position startPosition = node.getRange().getStart();
            Position endPosition = new Position(startPosition.getLine(), startPosition.getCharacter() + firstTokenString.length());
            children.add(SchemaRankExpressionParser.tokenFromRawText(context, node, simplifiedType, firstTokenString, new Range(startPosition, endPosition)));
        } else {
            int spacePos = firstTokenString.indexOf(32);
            Position startPosition = node.getRange().getStart();
            Position endPosition = new Position(startPosition.getLine(), startPosition.getCharacter() + spacePos);
            children.add(SchemaRankExpressionParser.tokenFromRawText(context, node, simplifiedType, firstTokenString.substring(0, spacePos), new Range(startPosition, endPosition)));
            children.add(SchemaRankExpressionParser.tokenFromRawText(context, node, Token.TokenType.INHERITS, firstTokenString.substring(spacePos + 1, firstTokenString.length()), new Range(new Position(endPosition.getLine(), endPosition.getCharacter() + 1), new Position(endPosition.getLine(), endPosition.getCharacter() + 1 + "inherits".length()))));
            SchemaNode inheritsIdentifierNode = SchemaRankExpressionParser.parseIdentifierWithDash(context, node, metaData.preText(), firstTokenString.length(), charPosition);
            Optional<Symbol> scope = CSTUtils.findScope(node);
            if (scope.isPresent()) {
                inheritsIdentifierNode.setSymbol(Symbol.SymbolType.RANK_PROFILE, context.fileURI(), scope.get());
            } else {
                inheritsIdentifierNode.setSymbol(Symbol.SymbolType.RANK_PROFILE, context.fileURI());
            }
            inheritsIdentifierNode.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
            children.add(inheritsIdentifierNode);
        }
        Position startPos = CSTUtils.addPositions(node.getRange().getStart(), metaData.expressionOffset());
        Position endPos = new Position(startPos.getLine(), startPos.getCharacter() + 1);
        children.add(SchemaRankExpressionParser.tokenFromRawText(context, node, charTokenType, "" + searchChar, new Range(startPos, endPos)));
        return children;
    }

    static void embedCST(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        if (!node.containsOtherLanguageData(Node.LanguageType.RANK_EXPRESSION)) {
            return;
        }
        ExpressionMetaData metaData = SchemaRankExpressionParser.findExpressionMetaData(node);
        ArrayList<SchemaNode> newChildren = SchemaRankExpressionParser.findPreChildren(context, metaData, node);
        if (newChildren == null) {
            return;
        }
        SchemaNode rankExpressionNode = SchemaRankExpressionParser.parseRankingExpression(context, node, metaData.expressionOffset(), diagnostics);
        if (rankExpressionNode != null) {
            newChildren.add(rankExpressionNode);
        }
        if (metaData.multiline()) {
            Position startPos = new Position(node.getRange().getEnd().getLine(), node.getRange().getEnd().getCharacter() - 1);
            Position endPos = node.getRange().getEnd();
            Range range = new Range(startPos, endPos);
            newChildren.add(SchemaRankExpressionParser.tokenFromRawText(context, node, Token.TokenType.RBRACE, "}", range));
        } else if (metaData.expressionOffset().getLine() > 0) {
            Position startPos = new Position(node.getRange().getEnd().getLine(), node.getRange().getEnd().getCharacter());
            Position endPos = new Position(node.getRange().getEnd().getLine(), node.getRange().getEnd().getCharacter() + 1);
            Range range = new Range(startPos, endPos);
            newChildren.add(SchemaRankExpressionParser.tokenFromRawText(context, node, Token.TokenType.NL, "\n", range));
        }
        node.clearChildren();
        node.addChildren(newChildren);
    }

    private record ExpressionMetaData(boolean multiline, boolean inherits, Position expressionOffset, String preText) {
    }
}

