/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals;

import ai.vespa.schemals.SchemaMessageHandler;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.context.EventContextCreator;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.lsp.common.command.ExecuteCommand;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.WorkspaceService;

public class SchemaWorkspaceService
implements WorkspaceService {
    private ClientLogger logger;
    private SchemaDocumentScheduler scheduler;
    private EventContextCreator eventContextCreator;

    public SchemaWorkspaceService(ClientLogger logger, SchemaDocumentScheduler scheduler, SchemaIndex schemaIndex, SchemaMessageHandler schemaMessageHandler) {
        this.logger = logger;
        this.scheduler = scheduler;
        this.eventContextCreator = new EventContextCreator(scheduler, schemaIndex, schemaMessageHandler);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams didChangeConfigurationParams) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams didChangeWatchedFilesParams) {
    }

    public void didDeleteFiles(DeleteFilesParams params) {
        List deletedFiles = params.getFiles();
        for (FileDelete file : deletedFiles) {
            this.scheduler.removeDocument(FileUtils.decodeURL(file.getUri()));
        }
    }

    public void didRenameFiles(RenameFilesParams params) {
        List renamedFiles = params.getFiles();
        for (FileRename file : renamedFiles) {
            this.scheduler.removeDocument(file.getOldUri());
            this.scheduler.addDocument(file.getNewUri());
        }
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            try {
                return ExecuteCommand.executeCommand(this.eventContextCreator.createContext(params));
            }
            catch (Exception ex) {
                this.logger.error("Internal error when executing command: " + ex.getMessage());
                return null;
            }
        });
    }
}

