/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.references;

import ai.vespa.schemals.context.EventPositionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Location;

public class SchemaReferences {
    public static List<Location> getReferences(EventPositionContext context) {
        boolean originalSymbolIsDefinition;
        ArrayList<Location> ret = new ArrayList<Location>();
        Node node = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (node == null) {
            return ret;
        }
        Symbol originalSymbol = node.getSymbol();
        if (originalSymbol.getStatus() == Symbol.SymbolStatus.INVALID || originalSymbol.getStatus() == Symbol.SymbolStatus.UNRESOLVED) {
            return ret;
        }
        Symbol search = originalSymbol;
        boolean bl = originalSymbolIsDefinition = originalSymbol.getStatus() == Symbol.SymbolStatus.DEFINITION;
        if (!originalSymbolIsDefinition) {
            Optional<Symbol> results = context.schemaIndex.getSymbolDefinition(originalSymbol);
            if (results.isEmpty()) {
                return ret;
            }
            search = results.get();
        }
        List<Symbol> symbols = context.schemaIndex.getSymbolReferences(search);
        if (!originalSymbolIsDefinition) {
            symbols.add(search);
        }
        for (Symbol symbol : symbols) {
            if (symbol == originalSymbol) continue;
            ret.add(symbol.getLocation());
        }
        return ret;
    }
}

