/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree;

import ai.vespa.schemals.parser.grouping.ast.request;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.YQL.YQLUtils;
import ai.vespa.schemals.tree.grouping.GroupingUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class YQLNode
extends Node {
    private ai.vespa.schemals.parser.yqlplus.Node originalYQLNode;
    private ai.vespa.schemals.parser.grouping.Node originalGroupingNode;
    private String customText;
    private int startCharOffset;

    public YQLNode(ai.vespa.schemals.parser.yqlplus.Node node, Position offset, int startCharOffset, String originalString) {
        super(Node.LanguageType.YQLPlus, CSTUtils.addPositionToRange(offset, YQLUtils.getNodeRange(node)), node.isDirty());
        this.originalYQLNode = node;
        this.startCharOffset = startCharOffset;
        this.customText = originalString.substring(node.getBeginOffset(), node.getEndOffset());
        for (ai.vespa.schemals.parser.yqlplus.Node child : node.children()) {
            this.addChild(new YQLNode(child, offset, startCharOffset, originalString));
        }
    }

    public YQLNode(ai.vespa.schemals.parser.yqlplus.Node node, Position offset, int startCharOffset) {
        super(Node.LanguageType.YQLPlus, CSTUtils.addPositionToRange(offset, YQLUtils.getNodeRange(node)), node.isDirty());
        this.originalYQLNode = node;
        this.startCharOffset = startCharOffset;
        for (ai.vespa.schemals.parser.yqlplus.Node child : node.children()) {
            this.addChild(new YQLNode(child, offset, startCharOffset));
        }
    }

    public YQLNode(ai.vespa.schemals.parser.grouping.Node node, Position rangeOffset, int startCharOffset) {
        super(Node.LanguageType.GROUPING, CSTUtils.addPositionToRange(rangeOffset, GroupingUtils.getNodeRange(node)), node.isDirty());
        this.originalGroupingNode = node;
        this.startCharOffset = startCharOffset;
        for (ai.vespa.schemals.parser.grouping.Node child : node.children()) {
            this.addChild(new YQLNode(child, rangeOffset, startCharOffset));
        }
    }

    public YQLNode(Range range) {
        super(Node.LanguageType.CUSTOM, range, false);
    }

    public YQLNode(Range range, String customText, int startCharOffset) {
        this(range);
        this.customText = customText;
        this.startCharOffset = startCharOffset;
    }

    public Range setRange(Range range) {
        this.range = range;
        return range;
    }

    @Override
    public String getText() {
        if (this.language == Node.LanguageType.YQLPlus) {
            if (this.customText != null) {
                return this.customText;
            }
            return this.originalYQLNode.getSource();
        }
        if (this.language == Node.LanguageType.GROUPING) {
            if (this.getASTClass() != request.class) {
                return this.originalGroupingNode.getSource();
            }
            if (this.originalGroupingNode.size() == 0) {
                return "";
            }
            ai.vespa.schemals.parser.grouping.Node lastChild = (ai.vespa.schemals.parser.grouping.Node)this.originalGroupingNode.get(this.originalGroupingNode.size() - 1);
            int beginOffset = this.originalGroupingNode.getBeginOffset();
            int endOffset = lastChild.getBeginOffset();
            return this.originalGroupingNode.getTokenSource().getText(beginOffset, endOffset);
        }
        if (this.customText != null) {
            return this.customText;
        }
        Object ret = "";
        for (int i = 0; i < this.size(); ++i) {
            Node child = this.get(i);
            ret = (String)ret + " " + child.getText();
        }
        if (((String)ret).length() == 0) {
            return "";
        }
        return ((String)ret).substring(1);
    }

    public ai.vespa.schemals.parser.grouping.Node getOriginalGroupingNode() {
        return this.originalGroupingNode;
    }

    @Override
    public boolean isYQLNode() {
        return true;
    }

    @Override
    public YQLNode getYQLNode() {
        return this;
    }

    @Override
    public Class<?> getASTClass() {
        if (this.language == Node.LanguageType.CUSTOM) {
            return YQLNode.class;
        }
        if (this.language == Node.LanguageType.YQLPlus) {
            return this.originalYQLNode.getClass();
        }
        if (this.language == Node.LanguageType.GROUPING) {
            return this.originalGroupingNode.getClass();
        }
        throw new RuntimeException("The YQLNode has an invalid languageType");
    }

    @Override
    public int getBeginOffset() {
        if (this.language == Node.LanguageType.YQLPlus) {
            return this.startCharOffset + this.originalYQLNode.getBeginOffset();
        }
        if (this.language == Node.LanguageType.GROUPING) {
            return this.startCharOffset + this.originalGroupingNode.getBeginOffset();
        }
        if (this.language == Node.LanguageType.CUSTOM) {
            return this.startCharOffset;
        }
        throw new RuntimeException("Could not find the begin offset of YQLNode.");
    }

    @Override
    public int getEndOffset() {
        if (this.language == Node.LanguageType.YQLPlus) {
            return this.startCharOffset + this.originalYQLNode.getEndOffset();
        }
        if (this.language == Node.LanguageType.GROUPING) {
            return this.startCharOffset + this.originalGroupingNode.getEndOffset();
        }
        if (this.language == Node.LanguageType.CUSTOM && this.size() > 0) {
            return this.get(this.size() - 1).getEndOffset();
        }
        if (this.language == Node.LanguageType.CUSTOM && this.customText != null) {
            return this.startCharOffset + this.customText.length();
        }
        throw new RuntimeException("Could not find the end offset of YQLNode.");
    }

    public String toString() {
        Range range = this.getRange();
        Position start = range.getStart();
        Position end = range.getEnd();
        return "YQLNode(" + this.getASTClass() + ", " + start.getLine() + "," + start.getCharacter() + "->" + end.getLine() + "," + end.getCharacter() + ")";
    }
}

