/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.common.editbuilder.WorkspaceEditBuilder;
import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class RunVespaQuery
implements SchemaCommand {
    private String queryCommand;
    private String sourceFileURI;

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        assert (arguments2.size() == this.getArity());
        if (!(arguments2.get(0) instanceof JsonPrimitive)) {
            return false;
        }
        if (!(arguments2.get(1) instanceof JsonPrimitive)) {
            return false;
        }
        JsonPrimitive arg0 = (JsonPrimitive)arguments2.get(0);
        this.queryCommand = arg0.getAsString();
        JsonPrimitive arg1 = (JsonPrimitive)arguments2.get(1);
        this.sourceFileURI = arg1.getAsString();
        return true;
    }

    @Override
    public Object execute(EventExecuteCommandContext context) {
        context.logger.info("Running Vespa query: " + this.queryCommand);
        this.runVespaQuery(this.queryCommand, context.logger).thenAccept(result -> {
            if (!result.success()) {
                if (result.result().toLowerCase().contains("cannot run program")) {
                    context.messageHandler.sendMessage(MessageType.Error, "Could not find vespa CLI. Make sure vespa CLI is installed and added to path. Download vespa CLI here: https://docs.vespa.ai/en/vespa-cli.html");
                    return;
                }
                context.messageHandler.sendMessage(MessageType.Error, "Failed to run query:\n" + result.result());
                return;
            }
            String response = result.result();
            String targetFileURI = RunVespaQuery.getTargetFileURI(this.sourceFileURI);
            CreateFile newFile = new CreateFile(targetFileURI);
            TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), response);
            WorkspaceEdit wsEdit = new WorkspaceEditBuilder().addResourceOperation((ResourceOperation)newFile).addTextEdit(targetFileURI, textEdit).build();
            context.messageHandler.applyEdit(new ApplyWorkspaceEditParams(wsEdit)).thenRun(() -> context.messageHandler.showDocument(targetFileURI));
        });
        return null;
    }

    private static String getTargetFileURI(String sourceFileURI) {
        Path filePath = Paths.get(sourceFileURI, new String[0]);
        Object fileName = filePath.getFileName().toString();
        fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46));
        ZonedDateTime now = ZonedDateTime.now();
        String isoDateTime = now.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        fileName = (String)fileName + "." + isoDateTime + ".json";
        return filePath.getParent().resolve((String)fileName).toString();
    }

    private CompletableFuture<QueryResult> runVespaQuery(String query, ClientLogger logger) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (isWindows) {
            builder.command("vespa.exe", "query", query);
        } else {
            builder.command("vespa", "query", query);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                String line;
                Process process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder output = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    return new QueryResult(true, output.toString());
                }
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder error = new StringBuilder();
                while ((line = errorReader.readLine()) != null) {
                    error.append(line).append("\n");
                }
                return new QueryResult(false, error.toString());
            }
            catch (InterruptedException e) {
                return new QueryResult(false, "Program interrupted");
            }
            catch (IOException e) {
                return new QueryResult(false, e.getMessage());
            }
        });
    }

    private record QueryResult(boolean success, String result) {
    }
}

