/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;

public class StringArgument
implements Argument {
    private String displayStr = "STRING";

    public StringArgument(String displayStr) {
        this.displayStr = displayStr;
    }

    @Override
    public int getStrictness() {
        return 2;
    }

    @Override
    public boolean validateArgument(RankNode node) {
        return true;
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        Node leaf = node.getSchemaNode();
        while (leaf.size() > 0) {
            if (leaf.hasSymbol()) {
                Symbol symbol = leaf.getSymbol();
                if (symbol.getStatus() == Symbol.SymbolStatus.REFERENCE) {
                    context.schemaIndex().deleteSymbolReference(symbol);
                }
                leaf.removeSymbol();
            }
            leaf = leaf.get(0);
        }
        return Optional.empty();
    }

    @Override
    public String displayString() {
        return this.displayStr;
    }
}

