/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser.schema;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.ast.COLON;
import ai.vespa.schemals.parser.ast.FIELD;
import ai.vespa.schemals.parser.ast.annotationRefDataType;
import ai.vespa.schemals.parser.ast.fieldRankFilter;
import ai.vespa.schemals.parser.ast.fieldRankType;
import ai.vespa.schemals.parser.ast.fieldsElm;
import ai.vespa.schemals.parser.ast.identifierWithDashStr;
import ai.vespa.schemals.parser.ast.importField;
import ai.vespa.schemals.parser.ast.inheritsAnnotation;
import ai.vespa.schemals.parser.ast.inheritsDocument;
import ai.vespa.schemals.parser.ast.inheritsDocumentSummary;
import ai.vespa.schemals.parser.ast.inheritsRankProfile;
import ai.vespa.schemals.parser.ast.inheritsStruct;
import ai.vespa.schemals.parser.ast.rankTypeElm;
import ai.vespa.schemals.parser.ast.referenceType;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.parser.ast.structFieldElm;
import ai.vespa.schemals.parser.ast.summaryInDocument;
import ai.vespa.schemals.parser.ast.summaryItem;
import ai.vespa.schemals.parser.ast.summarySourceList;
import ai.vespa.schemals.parser.rankingexpression.ast.BaseNode;
import ai.vespa.schemals.parser.rankingexpression.ast.LBRACE;
import ai.vespa.schemals.parser.rankingexpression.ast.args;
import ai.vespa.schemals.parser.rankingexpression.ast.identifierStr;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.schemadocument.resolvers.RankExpressionSymbolResolver;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.FunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class IdentifySymbolReferences
extends Identifier<SchemaNode> {
    private static final HashMap<Class<?>, Symbol.SymbolType> identifierTypeMap = new HashMap<Class<?>, Symbol.SymbolType>(){
        {
            this.put(inheritsDocument.class, Symbol.SymbolType.DOCUMENT);
            this.put(rootSchema.class, Symbol.SymbolType.SCHEMA);
            this.put(inheritsStruct.class, Symbol.SymbolType.STRUCT);
            this.put(referenceType.class, Symbol.SymbolType.DOCUMENT);
            this.put(inheritsAnnotation.class, Symbol.SymbolType.ANNOTATION);
            this.put(annotationRefDataType.class, Symbol.SymbolType.ANNOTATION);
        }
    };
    private static final HashMap<Class<?>, Symbol.SymbolType> identifierWithDashTypeMap = new HashMap<Class<?>, Symbol.SymbolType>(){
        {
            this.put(inheritsRankProfile.class, Symbol.SymbolType.RANK_PROFILE);
            this.put(inheritsDocumentSummary.class, Symbol.SymbolType.DOCUMENT_SUMMARY);
        }
    };
    private static final Set<Class<? extends Node>> fieldReferenceIdentifierParents = new HashSet<Class<? extends Node>>(){
        {
            this.add(fieldsElm.class);
            this.add(structFieldElm.class);
            this.add(summaryInDocument.class);
            this.add(summarySourceList.class);
            this.add(fieldRankFilter.class);
            this.add(fieldRankType.class);
            this.add(rankTypeElm.class);
        }
    };
    private static final Set<Class<?>> identifierNodes = new HashSet<Class<?>>(){
        {
            this.add(identifierStr.class);
            this.addAll(RankExpressionSymbolResolver.builtInTokenizedFunctions);
        }
    };

    public IdentifySymbolReferences(ParseContext context) {
        super(context);
    }

    public ArrayList<Diagnostic> identify(SchemaNode node) {
        if (node.hasSymbol()) {
            return new ArrayList<Diagnostic>();
        }
        if (node.getLanguageType() == Node.LanguageType.SCHEMA || node.getLanguageType() == Node.LanguageType.CUSTOM) {
            return this.identifySchemaLanguage(node);
        }
        if (node.getLanguageType() == Node.LanguageType.RANK_EXPRESSION) {
            return this.identifyRankExpressionLanguage(node);
        }
        return new ArrayList<Diagnostic>();
    }

    private ArrayList<Diagnostic> identifySchemaLanguage(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        boolean isIdentifier = node.isSchemaASTInstance(ai.vespa.schemals.parser.ast.identifierStr.class);
        boolean isIdentifierWithDash = node.isSchemaASTInstance(identifierWithDashStr.class);
        if (!isIdentifier && !isIdentifierWithDash) {
            return ret;
        }
        ai.vespa.schemals.tree.Node rawParent = node.getParent();
        if (rawParent == null) {
            return ret;
        }
        SchemaNode parent = rawParent.getSchemaNode();
        if (fieldReferenceIdentifierParents.contains(parent.getASTClass())) {
            return this.handleFieldReference(node);
        }
        if (parent.isASTInstance(importField.class)) {
            return this.handleImportField(node);
        }
        HashMap<Class<?>, Symbol.SymbolType> searchMap = isIdentifier ? identifierTypeMap : identifierWithDashTypeMap;
        Symbol.SymbolType symbolType = searchMap.get(parent.getASTClass());
        if (symbolType == null) {
            return ret;
        }
        Optional<Symbol> scope = CSTUtils.findScope(node);
        if (scope.isPresent()) {
            node.setSymbol(symbolType, this.context.fileURI(), scope.get());
        } else {
            node.setSymbol(symbolType, this.context.fileURI());
        }
        node.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
        if (parent.isSchemaASTInstance(referenceType.class)) {
            this.context.addUnresolvedDocumentReferenceNode(node);
        }
        return ret;
    }

    private ArrayList<Diagnostic> identifyRankExpressionLanguage(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (!identifierNodes.contains(node.getOriginalRankExpressionNode().getClass())) {
            return ret;
        }
        SchemaNode parent = node.getParent().getSchemaNode();
        if (!(parent.getOriginalRankExpressionNode() instanceof BaseNode)) {
            return ret;
        }
        ExpressionNode expressionNode = ((BaseNode)parent.getOriginalRankExpressionNode()).expressionNode;
        if (expressionNode instanceof ReferenceNode) {
            Symbol.SymbolType type = Symbol.SymbolType.TYPE_UNKNOWN;
            Reference reference = ((ReferenceNode)expressionNode).reference();
            String referenceTo = reference.name();
            if (!reference.isIdentifier()) {
                type = Symbol.SymbolType.FUNCTION;
            }
            Optional<Symbol> scope = CSTUtils.findScope(node);
            if (referenceTo.equals("file")) {
                return ret;
            }
            if (scope.isPresent()) {
                node.setSymbol(type, this.context.fileURI(), scope.get(), referenceTo);
            } else {
                node.setSymbol(type, this.context.fileURI(), null, referenceTo);
            }
            node.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
        } else if (parent.getOriginalRankExpressionNode() instanceof BaseNode && ((BaseNode)parent.getOriginalRankExpressionNode()).expressionNode instanceof FunctionNode) {
            Optional<Symbol> scope = CSTUtils.findScope(node);
            if (scope.isPresent()) {
                node.setSymbol(Symbol.SymbolType.FUNCTION, this.context.fileURI(), scope.get(), node.getText());
            } else {
                node.setSymbol(Symbol.SymbolType.FUNCTION, this.context.fileURI(), null, node.getText());
            }
            node.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
        } else if (parent.getIsDirty() && node.getNextSibling().isASTInstance(LBRACE.class) && node.getNextSibling().getNextSibling().isASTInstance(args.class)) {
            Optional<Symbol> scope = CSTUtils.findScope(node);
            if (scope.isPresent()) {
                node.setSymbol(Symbol.SymbolType.FUNCTION, this.context.fileURI(), scope.get());
            } else {
                node.setSymbol(Symbol.SymbolType.FUNCTION, this.context.fileURI());
            }
        }
        return ret;
    }

    private ArrayList<Diagnostic> handleFieldReference(SchemaNode identifierNode) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        ai.vespa.schemals.tree.Node parent = identifierNode.getParent();
        if (parent.isASTInstance(summaryInDocument.class) && this.summaryHasSourceList(parent)) {
            return ret;
        }
        if ((parent.isASTInstance(summaryInDocument.class) || parent.isASTInstance(summarySourceList.class)) && identifierNode.getText().equals("documentid")) {
            Optional<Symbol> scope = CSTUtils.findScope(identifierNode);
            if (scope.isPresent()) {
                identifierNode.setSymbol(Symbol.SymbolType.FIELD, this.context.fileURI(), scope.get());
            } else {
                identifierNode.setSymbol(Symbol.SymbolType.FIELD, this.context.fileURI());
            }
            identifierNode.setSymbolStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
            return ret;
        }
        if ((parent.isASTInstance(fieldRankType.class) || parent.isASTInstance(rankTypeElm.class)) && identifierNode.getPreviousSibling() != null && identifierNode.getPreviousSibling().isASTInstance(COLON.class)) {
            ArrayList<String> validRankTypes = new ArrayList<String>(){
                {
                    this.add("identity");
                    this.add("about");
                    this.add("tags");
                    this.add("empty");
                    this.add("default");
                }
            };
            if (!validRankTypes.contains(identifierNode.getText())) {
                Object msg = "Invalid rank type. Supported rank types are ";
                for (int i = 0; i < validRankTypes.size(); ++i) {
                    msg = (String)msg + "'" + (String)validRankTypes.get(i) + "'";
                    if (i >= validRankTypes.size() - 1) continue;
                    msg = (String)msg + ", ";
                }
                msg = (String)msg + ".";
                ret.add(new SchemaDiagnostic.Builder().setRange(identifierNode.getRange()).setMessage((String)msg).setSeverity(DiagnosticSeverity.Error).build());
            }
            return ret;
        }
        String fieldIdentifier = identifierNode.getText();
        String[] subfields = fieldIdentifier.split("[.]");
        int newStart = identifierNode.getRange().getStart().getCharacter();
        int newEnd = newStart + subfields[0].length();
        identifierNode.setNewEndCharacter(newEnd);
        if (identifierNode.size() != 0) {
            identifierNode.get(0).getSchemaNode().setNewEndCharacter(newEnd);
        }
        Optional<Symbol> scope = CSTUtils.findScope(identifierNode);
        Symbol.SymbolType firstType = Symbol.SymbolType.FIELD;
        if (parent.isASTInstance(structFieldElm.class)) {
            firstType = Symbol.SymbolType.SUBFIELD;
        }
        if (scope.isPresent()) {
            identifierNode.setSymbol(firstType, this.context.fileURI(), scope.get());
        } else {
            identifierNode.setSymbol(firstType, this.context.fileURI());
        }
        identifierNode.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
        int myIndex = parent.indexOf(identifierNode);
        for (int i = 1; i < subfields.length; ++i) {
            newStart += subfields[i - 1].length() + 1;
            newEnd += subfields[i].length() + 1;
            ai.vespa.schemals.parser.ast.identifierStr newASTNode = new ai.vespa.schemals.parser.ast.identifierStr();
            newASTNode.setTokenSource(identifierNode.getTokenSource());
            newASTNode.setBeginOffset(identifierNode.getOriginalSchemaNode().getBeginOffset());
            newASTNode.setEndOffset(identifierNode.getOriginalSchemaNode().getEndOffset());
            SchemaNode newNode = new SchemaNode(newASTNode);
            newNode.setNewStartCharacter(newStart);
            newNode.setNewEndCharacter(newEnd);
            parent.insertChildAfter(myIndex, newNode);
            scope = CSTUtils.findScope(newNode);
            if (scope.isPresent()) {
                newNode.setSymbol(Symbol.SymbolType.SUBFIELD, this.context.fileURI(), scope.get());
            } else {
                newNode.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
            }
            ++myIndex;
        }
        return ret;
    }

    private ArrayList<Diagnostic> handleImportField(SchemaNode identifierNode) {
        Optional<Symbol> scope;
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (!identifierNode.getPreviousSibling().isASTInstance(FIELD.class)) {
            return ret;
        }
        ai.vespa.schemals.tree.Node parent = identifierNode.getParent();
        String fieldIdentifier = identifierNode.getText();
        if (!fieldIdentifier.contains(".")) {
            return ret;
        }
        if (fieldIdentifier.endsWith(".") || fieldIdentifier.startsWith(".")) {
            ret.add(new SchemaDiagnostic.Builder().setRange(identifierNode.getRange()).setMessage("Expected an identifier").setSeverity(DiagnosticSeverity.Error).build());
            return ret;
        }
        String[] subfields = fieldIdentifier.split("[.]");
        int newStart = identifierNode.getRange().getStart().getCharacter();
        int newEnd = newStart + subfields[0].length();
        identifierNode.setNewEndCharacter(newEnd);
        if (identifierNode.size() != 0) {
            identifierNode.get(0).getSchemaNode().setNewEndCharacter(newEnd);
        }
        if ((scope = CSTUtils.findScope(identifierNode)).isPresent()) {
            identifierNode.setSymbol(Symbol.SymbolType.FIELD, this.context.fileURI(), scope.get());
        } else {
            identifierNode.setSymbol(Symbol.SymbolType.FIELD, this.context.fileURI());
        }
        identifierNode.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
        int myIndex = parent.indexOf(identifierNode);
        newStart += subfields[0].length() + 1;
        newEnd += subfields[1].length() + 1;
        ai.vespa.schemals.parser.ast.identifierStr newASTNode = new ai.vespa.schemals.parser.ast.identifierStr();
        newASTNode.setTokenSource(identifierNode.getTokenSource());
        newASTNode.setBeginOffset(identifierNode.getOriginalSchemaNode().getBeginOffset());
        newASTNode.setEndOffset(identifierNode.getOriginalSchemaNode().getEndOffset());
        SchemaNode newNode = new SchemaNode(newASTNode);
        newNode.setNewStartCharacter(newStart);
        newNode.setNewEndCharacter(newEnd);
        parent.insertChildAfter(myIndex, newNode);
        scope = CSTUtils.findScope(newNode);
        if (scope.isPresent()) {
            newNode.setSymbol(Symbol.SymbolType.SUBFIELD, this.context.fileURI(), scope.get());
        } else {
            newNode.setSymbol(Symbol.SymbolType.SUBFIELD, this.context.fileURI());
        }
        return ret;
    }

    private boolean summaryHasSourceList(ai.vespa.schemals.tree.Node summaryNode) {
        for (ai.vespa.schemals.tree.Node child : summaryNode) {
            if (!child.isASTInstance(summaryItem.class) || !child.get(0).isASTInstance(summarySourceList.class)) continue;
            return true;
        }
        return false;
    }
}

