## document

Contained in [documents](https://docs.vespa.ai/en/reference/services-content.html#documents). The document type to be routed to this content cluster.

| Attribute | Required |             Value              | Default |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|-----------|----------|--------------------------------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| type      | required | string                         |         | [Document type name](https://docs.vespa.ai/en/reference/schema-reference.html#document)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| mode      | required | index / store-only / streaming |         | The mode of storing and indexing. In this documentation, *index* is assumed unless explicitly mentioned *[streaming](https://docs.vespa.ai/en/streaming-search.html)* or *store-only* . Refer to *streaming search* for *store-only*, as documents are stored the same way for both cases. Changing mode requires an *indexing-mode-change* [validation override](https://docs.vespa.ai/en/reference/validation-overrides.html), and documents must be re-fed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| selection | optional | string                         |         | A [document selection](https://docs.vespa.ai/en/reference/document-select-language.html), restricting documents that are routed to this cluster. Defaults to a selection expression matching everything. This selection must apply to fields in *this document type only* . Selection will be merged together with selection for other types and global selection from [documents](https://docs.vespa.ai/en/reference/services-content.html#documents) to form a full expression for what documents belong to this cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| global    | optional | true / false                   | false   | Set to *true* to distribute all documents of this type to all nodes in the content cluster it is defined. Fields in global documents can be imported into documents to implement joins - read more in [parent/child](https://docs.vespa.ai/en/parent-child.html). Vespa will detect when a new (or outdated) node is added to the cluster and prevent it from taking part in searches until it has received all global documents. Changing from *false* to *true* or vice versa requires a *global-document-change* [validation override](https://docs.vespa.ai/en/reference/validation-overrides.html). First, [stop services](https://docs.vespa.ai/en/operations-selfhosted/admin-procedures.html#vespa-start-stop-restart) on all content nodes. Then, deploy with the validation override. Finally, [start services](https://docs.vespa.ai/en/operations-selfhosted/admin-procedures.html#vespa-start-stop-restart) on all content nodes. Note: *global* is only supported for *mode="index"*. |

[Read more](https://docs.vespa.ai/en/reference/services-content.html#document)
