## document-processing

Contained in [documents](https://docs.vespa.ai/en/reference/services-content.html#documents). Vespa Search specific configuration for which document processing cluster and chain to run index preprocessing.

| Attribute | Required | Value  |              Default              |                                                                                                                Description                                                                                                                 |
|-----------|----------|--------|-----------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| cluster   | optional | string | Container cluster on content node | Name of a [document-processing](https://docs.vespa.ai/en/reference/services-docproc.html) container cluster that does index preprocessing. Use cluster to specify an alternative cluster, other than the default cluster on content nodes. |
| chain     | optional | string | `indexing` chain                  | A document processing chain in the container cluster specified by *cluster* to use for index preprocessing. The chain must inherit the `indexing` chain.                                                                                   |

Example - the container cluster enables [document-processing](https://docs.vespa.ai/en/reference/services-docproc.html), referred to by the content cluster:


```xml
<container id="my-indexing-cluster" version="1.0">
    <document-processing/>
</container>
<content id="music" version="1.0">
    <documents>
        <document-processing cluster="my-indexing-cluster"/>
    </documents>
</content>

```


To add document processors either before or after the indexer, declare a chain (inherit *indexing* ) in a *document-processing* container cluster and add document processors. Annotate document processors with `before=indexingStart` or `after=indexingEnd`. Configure this cluster and chain as the indexing chain in the content cluster - example:


```xml
<container id="my-indexing-cluster" version="1.0">
    <document-processing>
        <chain id="my-document-processors"
               inherits="indexing">
            <documentprocessor id="MyDocproc">
                <before>indexingStart</before>
            </documentprocessor>
            <documentprocessor id="MyOtherDocproc">
                <after>indexingEnd</after>
            </documentprocessor>
        </chain>
    </document-processing>
</container>
<content id="music" version="1.0">
    <documents>
        <document-processing cluster="my-indexing-cluster"
                             chain="my-document-processors" />
    </documents>
</content>

```


Also note the [document-api](https://docs.vespa.ai/en/reference/services-container.html#document-api) configuration, applications can set up this API on the same nodes as *document-processing* - find details in [indexing](https://docs.vespa.ai/en/indexing.html).
[Read more](https://docs.vespa.ai/en/reference/services-content.html#document-processing)
