## bucket-splitting

Contained in [tuning](https://docs.vespa.ai/en/reference/services-content.html#tuning). The [bucket](https://docs.vespa.ai/en/content/buckets.html) is the fundamental unit of distribution and management in a content cluster. Buckets are auto-split, no need to configure for most applications.

|   Attribute   | Required |  Value  | Default |                                                                                                                                                                                                 Description                                                                                                                                                                                                 |
|---------------|----------|---------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| max-documents | optional | integer | 1024    | Maximum number of documents per content bucket. Buckets are split in two if they have more documents than this. Keep this value below 16K.                                                                                                                                                                                                                                                                  |
| max-size      | optional | integer | 32MiB   | Maximum size (in bytes) of a bucket. This is the sum of the serialized size of all documents kept in the bucket. Buckets are split in two if they have a larger size than this. Keep this value below 100 MiB.                                                                                                                                                                                              |
| minimum-bits  | optional | integer |         | Override the ideal distribution bit count configured for this cluster. Prefer to use the [distribution type](https://docs.vespa.ai/en/reference/services-content.html#distribution_type) setting instead if the default distribution bit count does not fit the cluster. This variable is intended for testing and to work around possible distribution bit issues. Most users should not need this option. |

[Read more](https://docs.vespa.ai/en/reference/services-content.html#bucket-splitting)
