## phase

Defines a phase, which is a named checkpoint to help order components inside a chain. Components and other phases may depend on a phase to be able to make assumptions about the order of components. Refer to the [Chained components](https://docs.vespa.ai/en/components/chained-components.html) guide.

| Attribute | Required | Value  | Default |                                                                                                                 Description                                                                                                                  |
|-----------|----------|--------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| id        | required | string |         | The ID, or name, which other phases and processors may depend upon as a [successor](https://docs.vespa.ai/en/reference/services-processing.html#before) or [predecessor](https://docs.vespa.ai/en/reference/services-processing.html#after). |
| before    | optional | string |         | Space-separated list of phases and/or processors which should succeed this phase                                                                                                                                                             |
| after     | optional | string |         | Space-separated list of phases and/or processors which should precede this phase                                                                                                                                                             |

Optional sub-elements:

* before: same as the attribute
* after: same as the attribute

These are equivalent:

```
<phase id="name">
    <before>phaseName1</before>
    <after>phaseName2</after>
</phase>

<phase id="name" before="phaseName1" after="phaseName2" />
```

Example:

```
<chain id="demo">
    <phase id="CheckpointName">
        <before>IntentAnalysis</before>
        <after>OtherAnalysis</after>
    </phase>
    <processor id="processor2" class="com.yahoo.test.Processor2"/>
</chain>
```

[Read more](https://docs.vespa.ai/en/reference/services-processing.html#phase)
