/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.parser.yqlplus.Node;
import ai.vespa.schemals.parser.yqlplus.ParseException;
import ai.vespa.schemals.parser.yqlplus.YQLPlusParser;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.SchemaDocumentLexer;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.YQL.YQLUtils;
import ai.vespa.schemals.tree.YQLNode;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;

public class YQLDocument
implements DocumentManager {
    boolean isOpen = false;
    String fileURI;
    String fileContent = "";
    ClientLogger logger;
    SchemaDiagnosticsHandler diagnosticsHandler;
    private YQLNode CST;

    YQLDocument(ClientLogger logger, SchemaDiagnosticsHandler diagnosticsHandler, String fileURI) {
        this.fileURI = fileURI;
        this.logger = logger;
        this.diagnosticsHandler = diagnosticsHandler;
    }

    @Override
    public void updateFileContent(String content) {
        this.fileContent = content;
        this.reparseContent();
    }

    @Override
    public void updateFileContent(String content, Integer version) {
        this.updateFileContent(content);
    }

    @Override
    public void reparseContent() {
        String charSequence = this.fileContent.toLowerCase();
        YQLPlusParser parser = new YQLPlusParser(charSequence);
        try {
            parser.statement();
        }
        catch (ParseException exception) {
            this.logger.error(exception.getMessage());
        }
        Node node = parser.rootNode();
        this.CST = new YQLNode(node);
        YQLUtils.printTree(this.logger, node);
    }

    @Override
    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    @Override
    public boolean getIsOpen() {
        return this.isOpen;
    }

    @Override
    public SchemaNode getRootNode() {
        return null;
    }

    @Override
    public YQLNode getRootYQLNode() {
        return this.CST;
    }

    @Override
    public SchemaDocumentLexer lexer() {
        return new SchemaDocumentLexer();
    }

    @Override
    public String getFileURI() {
        return this.fileURI;
    }

    @Override
    public String getCurrentContent() {
        return this.fileContent;
    }

    @Override
    public VersionedTextDocumentIdentifier getVersionedTextDocumentIdentifier() {
        return new VersionedTextDocumentIdentifier(this.fileURI, Integer.valueOf(0));
    }

    @Override
    public DocumentManager.DocumentType getDocumentType() {
        return DocumentManager.DocumentType.YQL;
    }
}

