/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.rename;

import ai.vespa.schemals.common.editbuilder.WorkspaceEditBuilder;
import ai.vespa.schemals.context.EventContext;
import ai.vespa.schemals.context.EventPositionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class SchemaRename {
    private static WorkspaceEditBuilder addTextEditsFromSymbols(WorkspaceEditBuilder builder, EventContext context, List<Symbol> symbols, String newName) {
        for (Symbol symbol : symbols) {
            DocumentManager manager = context.scheduler.getDocument(symbol.getFileURI());
            if (manager == null) {
                builder.addTextEdit(symbol.getFileURI(), new TextEdit(symbol.getNode().getRange(), newName));
                continue;
            }
            builder.addTextEdit(manager.getVersionedTextDocumentIdentifier(), new TextEdit(symbol.getNode().getRange(), newName));
        }
        return builder;
    }

    public static WorkspaceEdit rename(EventPositionContext context, String newName) {
        SchemaNode node = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (node == null || !node.hasSymbol()) {
            context.logger.error("Could not find symbol");
            return null;
        }
        Optional<Object> symbol = Optional.empty();
        Symbol.SymbolType type = node.getSymbol().getType();
        if (type == Symbol.SymbolType.DOCUMENT) {
            type = Symbol.SymbolType.SCHEMA;
            symbol = context.schemaIndex.getSchemaDefinition(node.getText());
        } else {
            symbol = context.schemaIndex.getSymbolDefinition(node.getSymbol());
        }
        if (symbol.isEmpty()) {
            context.messageHandler.sendMessage(MessageType.Error, "Could not find the symbol definition for: " + ((Symbol)symbol.get()).getShortIdentifier());
            return null;
        }
        SchemaDocument document = context.scheduler.getSchemaDocument(((Symbol)symbol.get()).getFileURI());
        if (document == null) {
            context.logger.error("Symbol has a fileURI to a file not in index!");
            return null;
        }
        ArrayList<Symbol> symbolOccurances = new ArrayList<Symbol>();
        symbolOccurances.addAll(context.schemaIndex.getSymbolReferences((Symbol)symbol.get()));
        symbolOccurances.add((Symbol)symbol.get());
        if (type == Symbol.SymbolType.SCHEMA) {
            return SchemaRename.renameSchema(context, document, (Symbol)symbol.get(), symbolOccurances, node.getText(), newName);
        }
        WorkspaceEditBuilder builder = new WorkspaceEditBuilder();
        builder = SchemaRename.addTextEditsFromSymbols(builder, context, symbolOccurances, newName);
        return builder.build();
    }

    private static WorkspaceEdit renameSchema(EventContext context, SchemaDocument document, Symbol symbol, List<Symbol> symbolOccurances, String oldName, String newName) {
        String newFileURI;
        Optional<Symbol> documentSymbol = context.schemaIndex.findSymbol(symbol, Symbol.SymbolType.DOCUMENT, oldName);
        if (documentSymbol.isPresent() && !documentSymbol.get().equals(symbol)) {
            symbolOccurances.add(documentSymbol.get());
            List<Symbol> documentReferences = context.schemaIndex.getSymbolReferences(documentSymbol.get());
            symbolOccurances.addAll(documentReferences);
        }
        if (context.scheduler.fileURIExists(newFileURI = document.getFilePath() + newName + ".sd") && !newFileURI.equals(document.getFileURI())) {
            context.messageHandler.sendMessage(MessageType.Error, "Cannot rename schema to '" + newName + "' since the name is already taken.");
            return null;
        }
        WorkspaceEditBuilder builder = new WorkspaceEditBuilder();
        builder.registerVersionedDocumentIdentifier(document.getVersionedTextDocumentIdentifier());
        if (!document.getFileURI().equals(newFileURI)) {
            builder.addResourceOperation((ResourceOperation)new RenameFile(document.getFileURI(), newFileURI));
        }
        builder = SchemaRename.addTextEditsFromSymbols(builder, context, symbolOccurances, newName);
        return builder.build();
    }
}

