/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.completion.provider;

import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.schema.completion.provider.CompletionProvider;
import ai.vespa.schemals.lsp.schema.completion.utils.CompletionUtils;
import ai.vespa.schemals.lsp.schema.hover.SchemaHover;
import ai.vespa.schemals.parser.ast.NL;
import ai.vespa.schemals.parser.ast.expression;
import ai.vespa.schemals.parser.ast.featureListElm;
import ai.vespa.schemals.parser.ast.openLbrace;
import ai.vespa.schemals.parser.rankingexpression.ast.feature;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.BuiltInFunctions;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.FunctionSignature;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.GenericFunction;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.SpecificFunction;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.EnumArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.KeywordArgument;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;

public class RankingExpressionCompletion
implements CompletionProvider {
    private static final List<CompletionItem> builtinFunctionCompletions = new ArrayList<CompletionItem>(){
        {
            HashSet<String> addedNames = new HashSet<String>();
            for (Map.Entry<String, GenericFunction> entry : BuiltInFunctions.rankExpressionBuiltInFunctions.entrySet()) {
                if (!(entry.getValue() instanceof GenericFunction)) continue;
                GenericFunction function2 = entry.getValue();
                String name = entry.getKey();
                for (List<FunctionSignature> group : RankingExpressionCompletion.groupSignatures(function2.getSignatures())) {
                    StringBuilder signatureStr = new StringBuilder("(");
                    signatureStr.append(String.join((CharSequence)", ", group.get(0).getArgumentList().stream().map(arg -> arg.displayString()).toList()));
                    signatureStr.append(")");
                    CompletionItem item = CompletionUtils.constructFunction(name, signatureStr.toString(), "builtin");
                    item.setInsertText(RankingExpressionCompletion.buildGroupInsertText(name, group));
                    SpecificFunction specificFunction = new SpecificFunction(entry.getValue(), group.get(0));
                    Optional<Hover> hover = SchemaHover.getRankFeatureHover(specificFunction);
                    if (hover.isPresent() && hover.get().getContents().isRight()) {
                        item.setDocumentation((MarkupContent)hover.get().getContents().getRight());
                    }
                    this.add(item);
                }
                addedNames.add(name);
            }
            for (String function3 : BuiltInFunctions.simpleBuiltInFunctionsSet) {
                if (addedNames.contains(function3)) continue;
                this.add(CompletionUtils.constructFunction(function3, "()", "builtin"));
            }
        }
    };

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        SchemaNode clean = CSTUtils.getLastCleanNode(context.document.getRootNode(), context.position);
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        if (this.matchFunctionCompletion(context, clean)) {
            result.addAll(this.getUserDefinedFunctions(context, clean));
            result.addAll(builtinFunctionCompletions);
        } else {
            result.addAll(this.getFunctionPropertyCompletion(context, CSTUtils.getNodeAtPosition(context.document.getRootNode(), context.startOfWord())));
        }
        return result;
    }

    private boolean matchFunctionCompletion(EventCompletionContext context, SchemaNode clean) {
        if (context.triggerCharacter.equals(Character.valueOf('.'))) {
            return false;
        }
        return clean.getLanguageType() == SchemaNode.LanguageType.RANK_EXPRESSION || clean.getParent() != null && (clean.getParent().isASTInstance(expression.class) || clean.getParent().isASTInstance(featureListElm.class));
    }

    String getFunctionSignature(Symbol functionDefinition) {
        StringBuilder signature = new StringBuilder();
        SchemaNode definitionNode = functionDefinition.getNode();
        SchemaNode it = definitionNode.getNextSibling();
        do {
            signature.append(it.getText());
        } while ((it = it.getNextSibling()) != null && !it.isASTInstance(NL.class) && !it.isASTInstance(openLbrace.class));
        return signature.toString();
    }

    List<CompletionItem> getUserDefinedFunctions(EventCompletionContext context, SchemaNode node) {
        Symbol scopeIterator;
        Optional<Symbol> scope = CSTUtils.findScope(node);
        if (scope.isEmpty()) {
            return List.of();
        }
        Symbol myFunction = null;
        for (scopeIterator = scope.get(); scopeIterator != null && scopeIterator.getType() != Symbol.SymbolType.RANK_PROFILE; scopeIterator = scopeIterator.getScope()) {
            if (scopeIterator.getType() == Symbol.SymbolType.LAMBDA_FUNCTION) {
                return List.of();
            }
            if (scopeIterator.getType() != Symbol.SymbolType.FUNCTION) continue;
            myFunction = scopeIterator;
        }
        if (scopeIterator == null) {
            return List.of();
        }
        ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
        for (Symbol symbol : context.schemaIndex.listSymbolsInScope(scopeIterator, Symbol.SymbolType.FUNCTION)) {
            if (symbol.equals(myFunction)) continue;
            ret.add(CompletionUtils.constructFunction(symbol.getShortIdentifier(), this.getFunctionSignature(symbol), symbol.getPrettyIdentifier()));
        }
        return ret;
    }

    List<CompletionItem> getFunctionPropertyCompletion(EventCompletionContext context, SchemaNode startOfWordNode) {
        if (context.triggerCharacter.charValue() != '.') {
            return List.of();
        }
        SchemaNode featureNode = CSTUtils.findASTClassAncestor(startOfWordNode, feature.class);
        if (featureNode == null || featureNode.size() == 0) {
            return List.of();
        }
        if (featureNode.getRankNode().isEmpty()) {
            return List.of();
        }
        RankNode rankNode = featureNode.getRankNode().get();
        Optional<SpecificFunction> functionSignature = rankNode.getFunctionSignature();
        if (functionSignature.isEmpty()) {
            return List.of();
        }
        SpecificFunction specificFunction = functionSignature.get();
        FunctionSignature signature = functionSignature.get().getSignature();
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        for (String prop : signature.getProperties()) {
            if (prop.isBlank()) continue;
            CompletionItem item = CompletionUtils.constructBasic(prop);
            specificFunction.setProperty(prop);
            Optional<Hover> documentationHover = SchemaHover.getRankFeatureHover(specificFunction);
            if (documentationHover.isPresent() && documentationHover.get().getContents().isRight()) {
                item.setDocumentation((MarkupContent)documentationHover.get().getContents().getRight());
            }
            result.add(item);
        }
        return result;
    }

    private static List<List<FunctionSignature>> groupSignatures(List<FunctionSignature> functionSignatures) {
        ArrayList<List<FunctionSignature>> ret = new ArrayList<List<FunctionSignature>>();
        HashSet<Integer> skip = new HashSet<Integer>();
        for (int i = 0; i < functionSignatures.size(); ++i) {
            if (skip.contains(i)) continue;
            final FunctionSignature current = functionSignatures.get(i);
            if (current.getArgumentList().isEmpty()) {
                ret.add(List.of(current));
                continue;
            }
            if (!(current.getArgumentList().get(0) instanceof KeywordArgument)) {
                ret.add(List.of(current));
                continue;
            }
            ArrayList<FunctionSignature> group = new ArrayList<FunctionSignature>(){
                {
                    this.add(current);
                }
            };
            for (int j = i + 1; j < functionSignatures.size(); ++j) {
                FunctionSignature candidate = functionSignatures.get(j);
                if (candidate.getArgumentList().size() != current.getArgumentList().size() || !(candidate.getArgumentList().get(0) instanceof KeywordArgument)) continue;
                skip.add(j);
                group.add(candidate);
            }
            ret.add((List<FunctionSignature>)group);
        }
        return ret;
    }

    private static String buildGroupInsertText(String name, List<FunctionSignature> group) {
        StringBuilder snippet = new StringBuilder().append(name).append("(");
        int startIndex = 0;
        if (group.size() > 1) {
            snippet.append("${1|").append(String.join((CharSequence)",", group.stream().map(signature -> ((KeywordArgument)signature.getArgumentList().get(0)).getArgument()).toList())).append("|}");
            startIndex = 1;
        }
        for (int i = startIndex; i < group.get(0).getArgumentList().size(); ++i) {
            if (i > 0) {
                snippet.append(", ");
            }
            Argument current = group.get(0).getArgumentList().get(i);
            snippet.append("${").append(i + 1);
            if (current instanceof EnumArgument) {
                snippet.append("|").append(String.join((CharSequence)",", ((EnumArgument)current).getValidArguments())).append("|}");
                continue;
            }
            snippet.append(":").append(current.displayString()).append("}");
        }
        snippet.append(")");
        return snippet.toString();
    }
}

