## processor

The definition of a single processor, for referencing when defining chains. If a single processor is to be used in multiple chains, it is cleaner to define it directly under `processing` and then refer to it with `idref`, than defining it inline separately for each chain.

| Attribute | Required | Value  | Default |                                      Description                                      |
|-----------|----------|--------|---------|---------------------------------------------------------------------------------------|
| id        | required | string |         | The component ID                                                                      |
| class     | optional | string |         | The class of the component, defaults to id                                            |
| bundle    | optional | string |         | The bundle to load the component from, defaults to class or id (if no class is given) |
| before    | optional | string |         | Space separated list of phases and/or processors which should succeed this processor  |
| after     | optional | string |         | Space separated list of phases and/or processors which should precede this processor  |

Example:

```
<processor id="processor2" class="com.yahoo.test.Processor2"/>
```

[Read more](https://docs.vespa.ai/en/reference/services-processing.html#processor)
