/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.FieldIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.schema.parser.ParsedType;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class ValidateFieldSettings {
    public static void validateFieldSettings(ParseContext context, SchemaNode fieldElmNode, List<Diagnostic> diagnostics) {
        EnumSet<FieldIndex.IndexingType> indexingTypes;
        dataType dataTypeNode;
        SchemaNode fieldIdentifierNode = fieldElmNode.get(1);
        if (!fieldIdentifierNode.hasSymbol() || fieldIdentifierNode.getSymbol().getType() != Symbol.SymbolType.FIELD || fieldIdentifierNode.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) {
            return;
        }
        if (fieldIdentifierNode.getNextSibling() != null && fieldIdentifierNode.getNextSibling().getNextSibling() != null && fieldIdentifierNode.getNextSibling().getNextSibling().isASTInstance(dataType.class) && (dataTypeNode = (dataType)fieldIdentifierNode.getNextSibling().getNextSibling().getOriginalSchemaNode()).getParsedType() != null && dataTypeNode.getParsedType().getVariant() == ParsedType.Variant.DOCUMENT && !(indexingTypes = context.fieldIndex().getFieldIndexingTypes(fieldIdentifierNode.getSymbol())).contains((Object)FieldIndex.IndexingType.ATTRIBUTE)) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(fieldIdentifierNode.getRange()).setMessage("Invalid document reference. The field must be an attribute.").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.DOCUMENT_REFERENCE_ATTRIBUTE).build());
        }
    }
}

