/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command;

import ai.vespa.schemals.lsp.common.command.commandtypes.CommandList;
import ai.vespa.schemals.lsp.common.command.commandtypes.DocumentOpen;
import ai.vespa.schemals.lsp.common.command.commandtypes.DocumentParse;
import ai.vespa.schemals.lsp.common.command.commandtypes.FindDocument;
import ai.vespa.schemals.lsp.common.command.commandtypes.HasSetupWorkspace;
import ai.vespa.schemals.lsp.common.command.commandtypes.RunVespaQuery;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import ai.vespa.schemals.lsp.common.command.commandtypes.SetupWorkspace;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;

public class CommandRegistry {
    public static List<String> getSupportedCommandList() {
        return Arrays.stream(CommandType.values()).map(commandType -> commandType.name()).toList();
    }

    public static Optional<SchemaCommand> getCommand(ExecuteCommandParams params) {
        try {
            CommandType commandType = CommandType.valueOf(params.getCommand());
            SchemaCommand command = commandType.construct();
            if (command.getArity() != -1 && command.getArity() != params.getArguments().size()) {
                return Optional.empty();
            }
            if (!command.setArguments(params.getArguments())) {
                return Optional.empty();
            }
            return Optional.of(command);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Command createLSPCommand(CommandType commandType, List<Object> arguments2) {
        return new Command(commandType.title(), commandType.name(), arguments2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CommandType implements GenericCommandType
    {
        DOCUMENT_OPEN{

            @Override
            public String title() {
                return "Open document";
            }

            @Override
            public SchemaCommand construct() {
                return new DocumentOpen();
            }
        }
        ,
        DOCUMENT_PARSE{

            @Override
            public String title() {
                return "Parse document";
            }

            @Override
            public SchemaCommand construct() {
                return new DocumentParse();
            }
        }
        ,
        COMMAND_LIST{

            @Override
            public String title() {
                return "Command list";
            }

            @Override
            public SchemaCommand construct() {
                return new CommandList();
            }
        }
        ,
        RUN_VESPA_QUERY{

            @Override
            public String title() {
                return "Run Vespa query";
            }

            @Override
            public SchemaCommand construct() {
                return new RunVespaQuery();
            }
        }
        ,
        FIND_SCHEMA_DEFINITION{

            @Override
            public String title() {
                return "Find schema document";
            }

            @Override
            public SchemaCommand construct() {
                return new FindDocument();
            }
        }
        ,
        HAS_SETUP_WORKSPACE{

            @Override
            public String title() {
                return "Has setup workspace";
            }

            @Override
            public SchemaCommand construct() {
                return new HasSetupWorkspace();
            }
        }
        ,
        SETUP_WORKSPACE{

            @Override
            public String title() {
                return "Setup workspace";
            }

            @Override
            public SchemaCommand construct() {
                return new SetupWorkspace();
            }
        };

    }

    public static interface GenericCommandType {
        public String title();

        public SchemaCommand construct();
    }
}

