/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.SchemaMessageHandler;
import ai.vespa.schemals.SchemaTextDocumentService;
import ai.vespa.schemals.SchemaWorkspaceService;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.documentation.FetchDocumentation;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.lsp.common.command.CommandRegistry;
import ai.vespa.schemals.lsp.common.semantictokens.CommonSemanticTokens;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class SchemaLanguageServer
implements LanguageServer,
LanguageClientAware {
    public static Path serverPath = null;
    private WorkspaceService workspaceService;
    private SchemaTextDocumentService textDocumentService;
    private SchemaDocumentScheduler schemaDocumentScheduler;
    private SchemaIndex schemaIndex;
    private SchemaDiagnosticsHandler schemaDiagnosticsHandler;
    private SchemaMessageHandler schemaMessageHandler = new SchemaMessageHandler();
    private int errorCode = 1;
    private LanguageClient client;
    private ClientLogger logger = new ClientLogger(this.schemaMessageHandler);

    public static void main(String[] args2) {
        System.out.println("This function may be useful at one point");
    }

    public SchemaLanguageServer() {
        this.schemaIndex = new SchemaIndex(this.logger);
        this.schemaDiagnosticsHandler = new SchemaDiagnosticsHandler();
        this.schemaDocumentScheduler = new SchemaDocumentScheduler(this.logger, this.schemaDiagnosticsHandler, this.schemaIndex, this.schemaMessageHandler);
        this.textDocumentService = new SchemaTextDocumentService(this.logger, this.schemaDocumentScheduler, this.schemaIndex, this.schemaMessageHandler);
        this.workspaceService = new SchemaWorkspaceService(this.logger, this.schemaDocumentScheduler, this.schemaIndex, this.schemaMessageHandler);
        serverPath = Paths.get(SchemaLanguageServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]).getParent();
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams initializeParams) {
        InitializeResult initializeResult = new InitializeResult(new ServerCapabilities());
        this.schemaMessageHandler.setTraceValue(initializeParams.getTrace());
        initializeResult.getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        CompletionOptions completionOptions = new CompletionOptions();
        completionOptions.setTriggerCharacters(List.of("."));
        initializeResult.getCapabilities().setCompletionProvider(completionOptions);
        initializeResult.getCapabilities().setHoverProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setDefinitionProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setReferencesProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setRenameProvider(new RenameOptions(Boolean.valueOf(true)));
        initializeResult.getCapabilities().setSemanticTokensProvider(CommonSemanticTokens.getSemanticTokensRegistrationOptions());
        initializeResult.getCapabilities().setDocumentSymbolProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setExecuteCommandProvider(new ExecuteCommandOptions(CommandRegistry.getSupportedCommandList()));
        initializeResult.getCapabilities().setCodeLensProvider(new CodeLensOptions());
        CodeActionOptions options = new CodeActionOptions(List.of("quickfix", "refactor", "refactor.rewrite"));
        initializeResult.getCapabilities().setCodeActionProvider(options);
        return CompletableFuture.supplyAsync(() -> initializeResult);
    }

    public void setTrace(SetTraceParams params) {
        this.schemaMessageHandler.setTraceValue(params.getValue());
    }

    public void initialized(InitializedParams params) {
    }

    public CompletableFuture<Object> shutdown() {
        this.errorCode = 0;
        return CompletableFutures.computeAsync(tmp -> {
            this.logger.info("Shutdown request received.");
            return null;
        });
    }

    public void exit() {
        System.exit(this.errorCode);
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public void connect(LanguageClient languageClient) {
        this.client = languageClient;
        this.schemaDiagnosticsHandler.connectClient(languageClient);
        this.schemaMessageHandler.connectClient(languageClient);
        this.client.logMessage(new MessageParams(MessageType.Log, "Language Server successfully connected to client."));
        if (serverPath == null) {
            return;
        }
        Path docPath = serverPath.resolve("hover");
        try {
            this.setupDocumentation(docPath);
        }
        catch (IOException ioex) {
            this.logger.error("Failed to set up documentation. Error: " + ioex.getMessage());
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();
                 PrintStream ps = new PrintStream(os);){
                ioex.printStackTrace(ps);
                this.logger.error(os.toString());
            }
            catch (IOException bruh) {
                this.logger.error("Error inside error " + bruh.getMessage());
            }
        }
    }

    public void setupDocumentation(final Path documentationPath) throws IOException {
        Files.createDirectories(documentationPath, new FileAttribute[0]);
        Files.createDirectories(documentationPath.resolve("schema"), new FileAttribute[0]);
        Files.createDirectories(documentationPath.resolve("rankExpression"), new FileAttribute[0]);
        Files.createDirectories(documentationPath.resolve("services"), new FileAttribute[0]);
        this.ensureLocalDocumentationLoaded(documentationPath);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    FetchDocumentation.fetchSchemaDocs(documentationPath);
                    FetchDocumentation.fetchServicesDocs(documentationPath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
        final ClientLogger logger = this.logger;
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                logger.warning("Failed to fetch docs: " + ex.getMessage() + " is unavailable. Locally cached documentation will be used.");
            }
        });
        logger.info("Fetching docs to path: " + documentationPath.toAbsolutePath().toString());
        thread.start();
    }

    private void ensureLocalDocumentationLoaded(Path documentationPath) throws IOException {
        File dir = new File(documentationPath.resolve("schema").toString());
        File[] contents = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".md");
            }
        });
        if (contents.length > 0) {
            return;
        }
        this.logger.info("Extracting embedded documentation files.");
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(documentationPath.getFileName().toString());
        if (!resources.hasMoreElements()) {
            throw new IOException("Could not find documentation in jar file!");
        }
        URL resourceURL = resources.nextElement();
        if (!resourceURL.getProtocol().equals("jar")) {
            throw new IOException("Unhandled protocol for resource " + resourceURL.toString());
        }
        String jarPath = resourceURL.getPath().substring(5, resourceURL.getPath().indexOf(33));
        try (JarFile jarFile = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(documentationPath.getFileName().toString())) continue;
                Path destination = documentationPath.getParent().resolve(entry.getName());
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(entry.getName());
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    String content = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    Files.write(destination, content.getBytes(), StandardOpenOption.CREATE);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }
}

