## cluster-controller

Contained in [tuning](https://docs.vespa.ai/en/reference/services-content.html#tuning). Tuning parameters for the cluster controller managing this cluster - child elements:

|          Element          | Required | Value |                                                                                                                            Default                                                                                                                            |                                                                                                                                                                                                                                                  Description                                                                                                                                                                                                                                                   |
|---------------------------|----------|-------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| init-progress-time        | optional |       |                                                                                                                                                                                                                                                               | If the initialization progress count have not been altered for this amount of seconds, the node is assumed to have deadlocked and is set down. Note that initialization may actually be prioritized lower now, so setting a low value here might cause false positives. Though if it is set down for wrong reason, when it will finish initialization and then be set up again.                                                                                                                                |
| transition-time           | optional |       | [storage_transition_time](https://github.com/vespa-engine/vespa/blob/master/configdefinitions/src/vespa/fleetcontroller.def) [distributor_transition_time](https://github.com/vespa-engine/vespa/blob/master/configdefinitions/src/vespa/fleetcontroller.def) | The transition time states how long (in seconds) a node will be in maintenance mode during what looks like a controlled restart. Keeping a node in maintenance mode during a restart allows a restart without the cluster trying to create new copies of all the data immediately. If the node has not started or got back up within the transition time, the node is set down, in which case, new full bucket copies will be created. Note separate defaults for distributor and storage (i.e. search) nodes. |
| max-premature-crashes     | optional |       | [max_premature_crashes](https://github.com/vespa-engine/vespa/blob/master/configdefinitions/src/vespa/fleetcontroller.def)                                                                                                                                    | The maximum number of crashes allowed before a content node is permanently set down by the cluster controller. If the node has a stable up or down state for more than the *stable-state-period*, the crash count is reset. However, resetting the count will not re-enable the node again if it has been disabled - restart the cluster controller to reset.                                                                                                                                                  |
| stable-state-period       | optional |       | [stable_state_time_period](https://github.com/vespa-engine/vespa/blob/master/configdefinitions/src/vespa/fleetcontroller.def)                                                                                                                                 | If a content node's state doesn't change for this many seconds, it's state is considered *stable*, clearing the premature crash count.                                                                                                                                                                                                                                                                                                                                                                         |
| min-distributor-up-ratio  | optional |       | [min_distributor_up_ratio](https://github.com/vespa-engine/vespa/blob/master/configdefinitions/src/vespa/fleetcontroller.def)                                                                                                                                 | The minimum ratio of distributors that are required to be *up* for the cluster state to be *up*.                                                                                                                                                                                                                                                                                                                                                                                                               |
| min-storage-up-ratio      | optional |       | [min_storage_up_ratio](https://github.com/vespa-engine/vespa/blob/master/configdefinitions/src/vespa/fleetcontroller.def)                                                                                                                                     | The minimum ratio of content nodes that are required to be *up* for the cluster state to be *up*.                                                                                                                                                                                                                                                                                                                                                                                                              |
| groups-allowed-down-ratio | optional |       |                                                                                                                                                                                                                                                               | A ratio for the number of content groups that are allowed to be down simultaneously. A value of 0.5 means that 50% of the groups are allowed to be down.                                                                                                                                                                                                                                                                                                                                                       |

[Read more](https://docs.vespa.ai/en/reference/services-content.html#cluster-controller)
