## jvm

JVM settings for container nodes:

|    Attribute     | Required |   Value    | Default |                                                        Description                                                         |
|------------------|----------|------------|---------|----------------------------------------------------------------------------------------------------------------------------|
| allocated-memory | optional | percentage |         | Memory to allocate to each JVM instance as a percentage of available memory. Must be an integer percentage followed by *%* |
| options          | optional | string     |         | Generic JVM options                                                                                                        |
| gc-options       | optional | string     |         | JVM GC options. Garbage Collector specific parameters                                                                      |

Example where 50% of the node total memory is used as the Max heap size of the JVM:

```
<nodes>
    <jvm gc-options="-XX:+UseG1GC -XX:MaxTenuringThreshold=10"
         options="-XX:+PrintCommandLineFlags"
         allocated-memory="50%" />
</nodes>
```

[Read more](https://docs.vespa.ai/en/reference/services-container.html#jvm)
