/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree;

import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.SubLanguageData;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.TokenSource;
import ai.vespa.schemals.parser.ast.expression;
import ai.vespa.schemals.parser.ast.featureListElm;
import ai.vespa.schemals.parser.ast.indexingElm;
import ai.vespa.schemals.parser.indexinglanguage.Token;
import ai.vespa.schemals.parser.rankingexpression.Node;
import ai.vespa.schemals.parser.rankingexpression.Token;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.indexinglanguage.ILUtils;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import ai.vespa.schemals.tree.rankingexpression.RankingExpressionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class SchemaNode
implements Iterable<SchemaNode> {
    private LanguageType language;
    private String identifierString;
    private Range range;
    private boolean isDirty = false;
    private Symbol symbolAtNode;
    private ArrayList<SchemaNode> children = new ArrayList();
    private SchemaNode parent;
    private ai.vespa.schemals.parser.Node originalSchemaNode;
    private ai.vespa.schemals.parser.indexinglanguage.Node originalIndexingNode;
    private Node originalRankExpressionNode;
    private String contentString;
    private Class<? extends ai.vespa.schemals.parser.Node> simulatedSchemaClass;
    private Token.TokenType schemaType;
    private Token.TokenType rankExpressionType;
    private Token.TokenType indexinglanguageType;
    private Optional<RankNode> rankNode = Optional.empty();

    private SchemaNode(LanguageType language, Range range, String identifierString, boolean isDirty) {
        this.language = language;
        this.range = range;
        this.identifierString = identifierString;
        this.isDirty = isDirty;
    }

    public SchemaNode(Range range, String contentString, String identifierString) {
        this(LanguageType.CUSTOM, range, identifierString, false);
        this.contentString = contentString;
    }

    public SchemaNode(ai.vespa.schemals.parser.Node node) {
        this(LanguageType.SCHEMA, CSTUtils.getNodeRange(node), node.getClass().getName(), node.isDirty());
        this.originalSchemaNode = node;
        this.schemaType = this.calculateSchemaType();
        for (ai.vespa.schemals.parser.Node child : node) {
            if (child == null) continue;
            SchemaNode newNode = new SchemaNode(child);
            newNode.setParent(this);
            this.children.add(newNode);
        }
    }

    public SchemaNode(ai.vespa.schemals.parser.indexinglanguage.Node node, Position rangeOffset) {
        this(LanguageType.INDEXING, CSTUtils.addPositionToRange(rangeOffset, ILUtils.getNodeRange(node)), node.getClass().getName(), node.isDirty());
        this.originalIndexingNode = node;
        if (node instanceof Token) {
            this.indexinglanguageType = (Token.TokenType)node.getType();
        }
        for (ai.vespa.schemals.parser.indexinglanguage.Node child : node) {
            if (child == null) continue;
            SchemaNode newNode = new SchemaNode(child, rangeOffset);
            newNode.setParent(this);
            this.children.add(newNode);
        }
    }

    public SchemaNode(Node node, Position rangeOffset) {
        this(LanguageType.RANK_EXPRESSION, CSTUtils.addPositionToRange(rangeOffset, RankingExpressionUtils.getNodeRange(node)), node.getClass().getName(), node.isDirty());
        this.originalRankExpressionNode = node;
        if (node instanceof ai.vespa.schemals.parser.rankingexpression.Token) {
            this.rankExpressionType = (Token.TokenType)node.getType();
        }
        for (Node child : node) {
            if (child == null) continue;
            SchemaNode newNode = new SchemaNode(child, rangeOffset);
            newNode.setParent(this);
            this.children.add(newNode);
        }
    }

    private void setParent(SchemaNode parent) {
        this.parent = parent;
    }

    public void addChild(SchemaNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void addChildren(List<SchemaNode> children) {
        for (SchemaNode child : children) {
            this.addChild(child);
        }
    }

    public void clearChildren() {
        for (SchemaNode child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    private Token.TokenType calculateSchemaType() {
        if (this.language != LanguageType.SCHEMA) {
            return null;
        }
        if (this.isDirty) {
            return null;
        }
        Node.NodeType nodeType = this.originalSchemaNode.getType();
        if (!(nodeType instanceof Token.TokenType)) {
            return null;
        }
        return (Token.TokenType)nodeType;
    }

    public Token.TokenType getSchemaType() {
        return this.schemaType;
    }

    public Token.TokenType getRankExpressionType() {
        return this.rankExpressionType;
    }

    public Token.TokenType getIndexingLanguageType() {
        return this.indexinglanguageType;
    }

    public Token.TokenType getDirtyType() {
        if (this.language != LanguageType.SCHEMA) {
            return null;
        }
        Node.NodeType originalType = this.originalSchemaNode.getType();
        if (originalType instanceof Token.TokenType) {
            return (Token.TokenType)originalType;
        }
        return null;
    }

    public Token.TokenType setSchemaType(Token.TokenType type) {
        if (this.language != LanguageType.SCHEMA && this.language != LanguageType.CUSTOM) {
            return null;
        }
        this.schemaType = type;
        return type;
    }

    public void setSymbol(Symbol.SymbolType type, String fileURI) {
        if (this.hasSymbol()) {
            throw new IllegalArgumentException("Cannot set symbol for node: " + this.toString() + ". Already has symbol.");
        }
        this.symbolAtNode = new Symbol(this, type, fileURI);
    }

    public void setSymbol(Symbol.SymbolType type, String fileURI, Symbol scope) {
        if (this.hasSymbol()) {
            throw new IllegalArgumentException("Cannot set symbol for node: " + this.toString() + ". Already has symbol.");
        }
        this.symbolAtNode = new Symbol(this, type, fileURI, scope);
    }

    public void setSymbol(Symbol.SymbolType type, String fileURI, Optional<Symbol> scope) {
        if (scope.isPresent()) {
            this.setSymbol(type, fileURI, scope.get());
        } else {
            this.setSymbol(type, fileURI);
        }
    }

    public void setSymbol(Symbol.SymbolType type, String fileURI, Symbol scope, String shortIdentifier) {
        if (this.hasSymbol()) {
            throw new IllegalArgumentException("Cannot set symbol for node: " + this.toString() + ". Already has symbol.");
        }
        this.symbolAtNode = new Symbol(this, type, fileURI, scope, shortIdentifier);
    }

    public void removeSymbol() {
        this.symbolAtNode = null;
    }

    public void setSymbolType(Symbol.SymbolType newType) {
        if (!this.hasSymbol()) {
            return;
        }
        this.symbolAtNode.setType(newType);
    }

    public void setSymbolStatus(Symbol.SymbolStatus newStatus) {
        if (!this.hasSymbol()) {
            return;
        }
        this.symbolAtNode.setStatus(newStatus);
    }

    public void setSymbolScope(Symbol newScope) {
        if (!this.hasSymbol()) {
            return;
        }
        this.symbolAtNode.setScope(newScope);
    }

    public boolean hasSymbol() {
        return this.symbolAtNode != null;
    }

    public Symbol getSymbol() {
        if (!this.hasSymbol()) {
            throw new IllegalArgumentException("get Symbol called on node without a symbol!");
        }
        return this.symbolAtNode;
    }

    public boolean containsOtherLanguageData(LanguageType language) {
        if (this.language != LanguageType.SCHEMA) {
            return false;
        }
        return language == LanguageType.INDEXING && this.originalSchemaNode instanceof indexingElm || language == LanguageType.RANK_EXPRESSION && (this.originalSchemaNode instanceof featureListElm || this.originalSchemaNode instanceof expression);
    }

    public boolean containsExpressionData() {
        if (this.language != LanguageType.SCHEMA) {
            return false;
        }
        return this.originalSchemaNode instanceof expression;
    }

    public SubLanguageData getILScript() {
        if (!this.containsOtherLanguageData(LanguageType.INDEXING)) {
            return null;
        }
        indexingElm elmNode = (indexingElm)this.originalSchemaNode;
        return elmNode.getILScript();
    }

    public String getRankExpressionString() {
        if (!this.containsOtherLanguageData(LanguageType.RANK_EXPRESSION)) {
            return null;
        }
        if (this.originalSchemaNode instanceof featureListElm) {
            featureListElm elmNode = (featureListElm)this.originalSchemaNode;
            return elmNode.getFeatureListString();
        }
        expression expressionNode = (expression)this.originalSchemaNode;
        return expressionNode.getExpressionString();
    }

    public boolean hasIndexingNode() {
        return false;
    }

    public boolean hasRankExpressionNode() {
        return false;
    }

    public ai.vespa.schemals.parser.Node getOriginalSchemaNode() {
        return this.originalSchemaNode;
    }

    public ai.vespa.schemals.parser.indexinglanguage.Node getOriginalIndexingNode() {
        return this.originalIndexingNode;
    }

    public Node getOriginalRankExpressionNode() {
        return this.originalRankExpressionNode;
    }

    public void setSimulatedASTClass(Class<? extends ai.vespa.schemals.parser.Node> astClass) {
        if (this.language != LanguageType.CUSTOM) {
            throw new IllegalArgumentException("Cannot set Simulated AST Class on a Schema node of type other than Custom");
        }
        this.simulatedSchemaClass = astClass;
    }

    public boolean isASTInstance(Class<?> astClass) {
        if (this.language == LanguageType.CUSTOM && astClass == this.simulatedSchemaClass) {
            return true;
        }
        if (this.language == LanguageType.SCHEMA) {
            return astClass.isInstance(this.originalSchemaNode);
        }
        if (this.language == LanguageType.RANK_EXPRESSION) {
            return astClass.isInstance(this.originalRankExpressionNode);
        }
        if (this.language == LanguageType.INDEXING) {
            return astClass.isInstance(this.originalIndexingNode);
        }
        return false;
    }

    public boolean isSchemaASTInstance(Class<? extends ai.vespa.schemals.parser.Node> astClass) {
        if (this.language == LanguageType.CUSTOM) {
            return astClass.equals(this.simulatedSchemaClass);
        }
        return astClass.isInstance(this.originalSchemaNode);
    }

    public boolean isRankExpressionASTInstance(Class<? extends Node> astClass) {
        return astClass.isInstance(this.originalRankExpressionNode);
    }

    public Class<?> getASTClass() {
        if (this.language == LanguageType.CUSTOM) {
            return this.simulatedSchemaClass;
        }
        if (this.language == LanguageType.SCHEMA && this.originalSchemaNode != null) {
            return this.originalSchemaNode.getClass();
        }
        if (this.language == LanguageType.RANK_EXPRESSION && this.originalRankExpressionNode != null) {
            return this.originalRankExpressionNode.getClass();
        }
        if (this.language == LanguageType.INDEXING && this.originalIndexingNode != null) {
            return this.originalIndexingNode.getClass();
        }
        return null;
    }

    public String getIdentifierString() {
        return this.identifierString;
    }

    public void setNewStartCharacter(int startCharacter) {
        if (this.originalSchemaNode == null) {
            return;
        }
        int currentOffset = this.originalSchemaNode.getBeginOffset();
        int characterDelta = startCharacter - this.range.getStart().getCharacter();
        this.originalSchemaNode.setBeginOffset(currentOffset + characterDelta);
        this.range = CSTUtils.getNodeRange(this.originalSchemaNode);
    }

    public void setNewEndCharacter(int endCharacter) {
        if (this.originalSchemaNode == null) {
            return;
        }
        int currentOffset = this.originalSchemaNode.getEndOffset();
        int characterDelta = endCharacter - this.range.getEnd().getCharacter();
        this.originalSchemaNode.setEndOffset(currentOffset + characterDelta);
        this.range = CSTUtils.getNodeRange(this.originalSchemaNode);
    }

    public int getOriginalBeginOffset() {
        switch (this.language) {
            case SCHEMA: {
                if (this.originalSchemaNode == null) {
                    return -1;
                }
                return this.originalSchemaNode.getBeginOffset();
            }
            case INDEXING: {
                if (this.originalIndexingNode == null) {
                    return -1;
                }
                return this.originalIndexingNode.getBeginOffset();
            }
            case RANK_EXPRESSION: {
                if (this.originalRankExpressionNode == null) {
                    return -1;
                }
                return this.originalRankExpressionNode.getBeginOffset();
            }
        }
        return -1;
    }

    public String getClassLeafIdentifierString() {
        if (this.language == LanguageType.CUSTOM && this.getASTClass() != null) {
            return this.getASTClass().getSimpleName();
        }
        int lastIndex = this.identifierString.lastIndexOf(46);
        return this.identifierString.substring(lastIndex + 1);
    }

    public Range getRange() {
        return this.range;
    }

    public SchemaNode getParent(int levels) {
        if (levels == 0) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getParent(levels - 1);
    }

    public SchemaNode getParent() {
        return this.getParent(1);
    }

    public void insertChildAfter(int index, SchemaNode child) {
        this.children.add(index + 1, child);
        child.setParent(this);
    }

    public SchemaNode getPrevious() {
        if (this.parent == null) {
            return null;
        }
        int parentIndex = this.parent.indexOf(this);
        if (parentIndex == -1) {
            return null;
        }
        if (parentIndex == 0) {
            return this.parent;
        }
        return this.parent.get(parentIndex - 1);
    }

    public SchemaNode getNext() {
        if (this.parent == null) {
            return null;
        }
        int parentIndex = this.parent.indexOf(this);
        if (parentIndex == -1) {
            return null;
        }
        if (parentIndex == this.parent.size() - 1) {
            return this.parent.getNext();
        }
        return this.parent.get(parentIndex + 1);
    }

    public SchemaNode getSibling(int relativeIndex) {
        if (this.parent == null) {
            return null;
        }
        int parentIndex = this.parent.indexOf(this);
        if (parentIndex == -1) {
            return null;
        }
        int siblingIndex = parentIndex + relativeIndex;
        if (siblingIndex < 0 || siblingIndex >= this.parent.size()) {
            return null;
        }
        return this.parent.get(siblingIndex);
    }

    public SchemaNode getPreviousSibling() {
        return this.getSibling(-1);
    }

    public SchemaNode getNextSibling() {
        return this.getSibling(1);
    }

    public int indexOf(SchemaNode child) {
        return this.children.indexOf(child);
    }

    public int size() {
        return this.children.size();
    }

    public SchemaNode get(int i) {
        return this.children.get(i);
    }

    public String getText() {
        if (this.language == LanguageType.SCHEMA) {
            return this.originalSchemaNode.getSource();
        }
        if (this.language == LanguageType.INDEXING) {
            return this.originalIndexingNode.getSource();
        }
        if (this.language == LanguageType.RANK_EXPRESSION) {
            return this.originalRankExpressionNode.getSource();
        }
        if (this.language == LanguageType.CUSTOM) {
            return this.contentString;
        }
        return null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public SchemaNode findFirstLeaf() {
        SchemaNode ret = this;
        while (ret.size() > 0) {
            ret = ret.get(0);
        }
        return ret;
    }

    public boolean getIsDirty() {
        return this.isDirty;
    }

    public IllegalArgumentException getIllegalArgumentException() {
        if (this.language == LanguageType.SCHEMA && this.originalSchemaNode instanceof ai.vespa.schemals.parser.Token) {
            return ((ai.vespa.schemals.parser.Token)this.originalSchemaNode).getIllegalArguemntException();
        }
        return null;
    }

    public Token.ParseExceptionSource getParseExceptionSource() {
        if (this.language == LanguageType.SCHEMA && this.originalSchemaNode instanceof ai.vespa.schemals.parser.Token) {
            return ((ai.vespa.schemals.parser.Token)this.originalSchemaNode).getParseExceptionSource();
        }
        return null;
    }

    public TokenSource getTokenSource() {
        if (this.language == LanguageType.SCHEMA) {
            return this.originalSchemaNode.getTokenSource();
        }
        return null;
    }

    public LanguageType getLanguageType() {
        return this.language;
    }

    public void setRankNode(RankNode node) {
        this.rankNode = Optional.of(node);
    }

    public Optional<RankNode> getRankNode() {
        return this.rankNode;
    }

    public String toString() {
        Position pos = this.getRange().getStart();
        String astClassStr = this.getASTClass() == null ? "AST_NULL" : this.getASTClass().toString();
        astClassStr = astClassStr.substring(astClassStr.lastIndexOf(46) + 1);
        String ret = "Node('" + this.getText() + "', [" + astClassStr + "] at " + pos.getLine() + ":" + pos.getCharacter();
        if (this.hasSymbol()) {
            ret = ret + " [SYMBOL " + this.getSymbol().getType().toString() + " " + this.getSymbol().getStatus().toString() + ": " + this.getSymbol().getLongIdentifier() + "]";
        }
        ret = ret + ")";
        return ret;
    }

    @Override
    public Iterator<SchemaNode> iterator() {
        return new Iterator<SchemaNode>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < SchemaNode.this.children.size();
            }

            @Override
            public SchemaNode next() {
                return SchemaNode.this.children.get(this.currentIndex++);
            }
        };
    }

    public static enum LanguageType {
        SCHEMA,
        INDEXING,
        RANK_EXPRESSION,
        CUSTOM;

    }
}

