/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.completion.provider;

import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.completion.provider.CompletionProvider;
import ai.vespa.schemals.lsp.completion.utils.CompletionUtils;
import ai.vespa.schemals.parser.ast.NL;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.parser.ast.openLbrace;
import ai.vespa.schemals.parser.ast.structFieldElm;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;

public class StructFieldCompletion
implements CompletionProvider {
    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        if (!(context.document instanceof SchemaDocument)) {
            return List.of();
        }
        SchemaNode lastCleanNode = CSTUtils.getLastCleanNode(context.document.getRootNode(), context.startOfWord());
        if (lastCleanNode == null || !lastCleanNode.isASTInstance(NL.class) || lastCleanNode.getParent() == null) {
            return List.of();
        }
        SchemaNode parent = lastCleanNode.getParent();
        if (parent.isASTInstance(openLbrace.class)) {
            parent = parent.getParent();
        }
        if (!parent.isASTInstance(fieldElm.class) && !parent.isASTInstance(structFieldElm.class)) {
            return List.of();
        }
        SchemaNode fieldDefinitionNode = parent.get(1);
        if (!fieldDefinitionNode.hasSymbol()) {
            return List.of();
        }
        Optional<Symbol> definition = context.schemaIndex.getFirstSymbolDefinition(fieldDefinitionNode.getSymbol());
        if (definition.isEmpty()) {
            return List.of();
        }
        Optional<Symbol> structDefinition = context.schemaIndex.fieldIndex().findFieldStructDefinition(definition.get());
        if (structDefinition.isEmpty()) {
            return List.of();
        }
        List<Symbol> fieldsInStruct = context.schemaIndex.listSymbolsInScope(structDefinition.get(), EnumSet.of(Symbol.SymbolType.FIELD, Symbol.SymbolType.MAP_KEY, Symbol.SymbolType.MAP_VALUE));
        if (fieldsInStruct.isEmpty()) {
            return List.of(CompletionUtils.constructBasic("struct-field"));
        }
        Object choiceString = String.join((CharSequence)",", fieldsInStruct.stream().map(symbol -> symbol.getShortIdentifier()).toList());
        if (fieldsInStruct.size() == 1 && fieldsInStruct.get(0).getType() == Symbol.SymbolType.MAP_KEY) {
            choiceString = (String)choiceString + ",value";
        }
        choiceString = "${1|" + (String)choiceString + "|}";
        return List.of(CompletionUtils.constructSnippet("struct-field", "struct-field " + (String)choiceString + " {\n\t$0\n}"));
    }
}

