## match

Contained in [field](https://docs.vespa.ai/en/reference/schema-reference.html#field), [fieldset](https://docs.vespa.ai/en/reference/schema-reference.html#fieldset) or [struct-field](https://docs.vespa.ai/en/reference/schema-reference.html#struct-field). Sets the matching method to use for this field to something else than the default token matching.

```
match: [property]
```

or

```
match {
    [property]
    [property]
    …
}
```

Whether the match type is `text`, `word` or `exact`, all term matching will be done after [normalization](https://docs.vespa.ai/en/linguistics.html#normalization) and locale independent lowercasing (in that order).

Find examples and more details in the [Text Matching](https://docs.vespa.ai/en/text-matching.html) guide. Also see search using [regular expressions](https://docs.vespa.ai/en/reference/query-language-reference.html#matches).

|     Property     |                              Valid with                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                     Description                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
|------------------|-----------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| text             | index                                                                 | Default for string fields with `index`. Can not be combined with exact matching. The field is matched per [token](https://docs.vespa.ai/en/linguistics.html#tokenization).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| exact            | index, attribute                                                      | Can not be combined with *text* matching. The field is matched *exactly*: Strings containing any characters whatsoever will be indexed and matched as-is. In queries, the exact match string ends at the exact match terminator (below). A field with `match: exact` is considered to be a [filter field](https://docs.vespa.ai/en/reference/schema-reference.html#filter), just as if `rank: filter` was specified. This is because there is only one word per field (or per item in the case of multivalued types such as `array<string>`), so there little ranking information. Turn off the implicit `rank: filter` by adding `rank: normal`.                                                                                                                                                                                                                                                                    |
| exact-terminator | index, attribute                                                      | Only valid for `match: exact`. Default is `@@`. Specify terminator in [query strings](https://docs.vespa.ai/en/reference/query-api-reference.html#model.querystring). If the query strings can contain `@@`, set a different terminator, or use `match: word`, see below. Example - use: ``` match { exact exact-terminator: "@%" } ``` on a field called `tag` to make query `tag:a b c!@%` match documents with the string *a b c!* Example using the default terminator: If `tag` is an exact match field, the query: ``` someword AND (tag:!*!@@ OR tag:(kanoo)@@) ``` matches documents with `someword` and either `!*!` or `(kanoo)` as a tag. Note that without the `@@` terminating the second tag string, the second tag value would be `(kanoo))`.                                                                                                                                                         |
| word             | index, attribute                                                      | This is the default matching mode for [string attributes](https://docs.vespa.ai/en/attributes.html). Can not be combined with *text* matching. Word matching is like exact matching, but with more advanced query parsing. The query terms is heuristically parsed taking into account some usual query syntax characters; one can also use double quotes to include space, star, or exclamation marks. Example: If `artist` is a string attribute, the query: ``` foo AND (artist:"'N Sync" OR artist:"*NSYNC" OR artist:A*teens OR artist:"Wham!") ``` matches documents with `foo` and at least one of `'N Sync` or `*NSYNC` or `A*teens` or `Wham!` in the artist field Note that without the quotes, the space in `'N Sync` would end that word and would result in a search for just `'N`, similarly the `!` would mean to increase the weight of a `Wham` term if not quoted.                                 |
| prefix           | attribute                                                             | Has no effect as [attributes](https://docs.vespa.ai/en/attributes.html) always support prefix searches. Prefix matching must be [specified in the query](https://docs.vespa.ai/en/reference/query-language-reference.html#prefix). See also [regular expressions](https://docs.vespa.ai/en/reference/query-language-reference.html#matches).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| substring        | [Streaming mode](https://docs.vespa.ai/en/streaming-search.html) only | Set default match mode to *substring* for the field. Only available in streaming search. As the data structures in streaming search support substring searches, one can always set substring matching in the query, without setting the field to substring default. Also see [regular expressions](https://docs.vespa.ai/en/reference/query-language-reference.html#matches).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| suffix           | [Streaming mode](https://docs.vespa.ai/en/streaming-search.html) only | Like substring above.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| cased            | attribute                                                             | Enable case-sensitive matching. Only relevant for string attributes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| uncased          | index, attribute                                                      | Enable case-insensitive matching. This is the default for all string fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| max-length       | index                                                                 | Limit the length of the field that will be used for matching. By default, only the first 1M characters are indexed. [Example](https://docs.vespa.ai/en/schemas.html#field-size). When adjusting this limit, it might also be needed to adjust [max-occurrences](https://docs.vespa.ai/en/reference/schema-reference.html#max-occurrences).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| max-occurrences  | index                                                                 | Configure the max number of occurrences that will be indexed for each unique token/term in the field for a given document. It this limit is reached, consecutive occurrences of the same token/term are ignored for that document. The default value is 10000. Adjusting this limit might be needed when using the [phrase](https://docs.vespa.ai/en/reference/query-language-reference.html#phrase), [near](https://docs.vespa.ai/en/reference/query-language-reference.html#near), or [onear](https://docs.vespa.ai/en/reference/query-language-reference.html#onear) query operators to query documents with large field values (see [max-length](https://docs.vespa.ai/en/reference/schema-reference.html#max-length)) that contain more than 10000 occurrences of common tokens/terms. When using these operators it is only possible to match among the first *max-occurrences* of a token/term in a document. |
| max-token-length | index                                                                 | Configure the max length of tokens that will be indexed for the field. Longer tokens are silently ignored. The unit is characters (cf. java.lang.String.length()). The default value is 1000.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| gram             | index                                                                 | This field is matched using n-grams. For example, with the default gram size 2 the string "hi blue" is tokenized to "hi bl lu ue" both in the index and in queries to the index. N-gram matching is useful mainly as an alternative to [segmentation](https://docs.vespa.ai/en/linguistics.html#tokenization) in CJK languages. Typically, it results in increased recall and lower precision. However, as Vespa usually uses proximity in ranking, the precision offset may not be of much importance. Grams consume more resources than other matching methods because both indexes and queries will have more terms, and the terms contains repetition of the same letters. On the other hand, CPU intensive CJK segmentation is avoided. It may also be used for substring matching in general.                                                                                                                  |
| gram-size        | index                                                                 | A positive, nonzero, number, default 2. Sets the gram size when gram matching is used. Example: ``` match { gram gram-size: 3 } ```                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |

[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#match)
