/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree.rankingexpression;

import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.rankingexpression.ast.args;
import ai.vespa.schemals.parser.rankingexpression.ast.expression;
import ai.vespa.schemals.parser.rankingexpression.ast.feature;
import ai.vespa.schemals.parser.rankingexpression.ast.lambdaFunction;
import ai.vespa.schemals.parser.rankingexpression.ast.outs;
import ai.vespa.schemals.parser.rankingexpression.ast.scalarOrTensorFunction;
import ai.vespa.schemals.parser.rankingexpression.ast.tensorReduceComposites;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.SpecificFunction;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.Range;

public class RankNode
implements Iterable<RankNode> {
    private static Map<Class<?>, ReturnType> BuiltInReturnType = new HashMap<Class<?>, ReturnType>(){
        {
            this.put(tensorReduceComposites.class, ReturnType.TENSOR);
            this.put(scalarOrTensorFunction.class, ReturnType.DOUBLE);
        }
    };
    private SchemaNode schemaNode;
    private RankNodeType type;
    private ReturnType returnType;
    private boolean insideLambdaFunction = false;
    private boolean arugmentListExists = false;
    private List<RankNode> children;
    private Optional<SchemaNode> property;
    private Optional<SpecificFunction> functionSignature = Optional.empty();
    private static final Map<Class<?>, RankNodeType> rankNodeTypeMap = new HashMap<Class<?>, RankNodeType>(){
        {
            this.put(feature.class, RankNodeType.FEATURE);
            this.put(expression.class, RankNodeType.EXPRESSION);
            this.put(scalarOrTensorFunction.class, RankNodeType.BUILT_IN_FUNCTION);
            this.put(tensorReduceComposites.class, RankNodeType.BUILT_IN_FUNCTION);
            this.put(lambdaFunction.class, RankNodeType.BUILT_IN_FUNCTION);
        }
    };

    public static boolean validReturnType(ReturnType expected, ReturnType recieved) {
        if (expected == recieved) {
            return true;
        }
        if (recieved == ReturnType.UNKNOWN) {
            return true;
        }
        if (recieved == ReturnType.INTEGER) {
            return RankNode.validReturnType(expected, ReturnType.DOUBLE);
        }
        if (recieved == ReturnType.DOUBLE) {
            return RankNode.validReturnType(expected, ReturnType.STRING);
        }
        return false;
    }

    private RankNode(SchemaNode node) {
        this.schemaNode = node;
        this.type = rankNodeTypeMap.get(node.getASTClass());
        this.returnType = ReturnType.UNKNOWN;
        node.setRankNode(this);
        if (this.type == RankNodeType.EXPRESSION) {
            this.children = RankNode.findChildren(node);
        } else if (this.type == RankNodeType.FEATURE) {
            Optional<List<RankNode>> children = RankNode.findParameters(node);
            if (children.isPresent()) {
                this.children = children.get();
                this.arugmentListExists = true;
            } else {
                this.children = new ArrayList<RankNode>();
            }
            this.property = RankNode.findProperty(node);
            if (this.property.isPresent()) {
                this.property.get().setRankNode(this);
            }
        } else if (this.type == RankNodeType.BUILT_IN_FUNCTION) {
            this.children = RankNode.findBuiltInChildren(node);
            this.returnType = BuiltInReturnType.get(node.getASTClass());
        }
        if (node.isASTInstance(lambdaFunction.class)) {
            this.setInsideLambdaFunction();
        }
    }

    private static List<RankNode> findChildren(SchemaNode node) {
        ArrayList<RankNode> ret = new ArrayList<RankNode>();
        for (SchemaNode child : node) {
            if (rankNodeTypeMap.containsKey(child.getASTClass())) {
                ret.add(new RankNode(child));
                continue;
            }
            ret.addAll(RankNode.findChildren(child));
        }
        return ret;
    }

    private static Optional<List<RankNode>> findParameters(SchemaNode node) {
        SchemaNode parameterNode = null;
        for (int i = 0; i < node.size(); ++i) {
            if (!node.get(i).isASTInstance(args.class)) continue;
            parameterNode = node.get(i);
            break;
        }
        if (parameterNode == null) {
            return Optional.empty();
        }
        ArrayList<RankNode> ret = new ArrayList<RankNode>();
        for (SchemaNode child : parameterNode) {
            if (!child.isASTInstance(expression.class)) continue;
            ret.add(new RankNode(child));
        }
        return Optional.of(ret);
    }

    private static List<RankNode> findBuiltInChildren(SchemaNode node) {
        ArrayList<RankNode> ret = new ArrayList<RankNode>();
        for (SchemaNode child : node) {
            if (!child.isASTInstance(expression.class)) continue;
            ret.add(new RankNode(child));
        }
        return ret;
    }

    private static Optional<SchemaNode> findProperty(SchemaNode node) {
        SchemaNode propertyNode = null;
        for (int i = 0; i < node.size(); ++i) {
            if (!node.get(i).isASTInstance(outs.class)) continue;
            propertyNode = node.get(i);
            break;
        }
        if (propertyNode == null || propertyNode.size() == 0 || propertyNode.getRange().getStart().equals((Object)propertyNode.getRange().getEnd())) {
            return Optional.empty();
        }
        return Optional.of(propertyNode.get(0));
    }

    public static List<RankNode> createTree(SchemaNode node) {
        return RankNode.findChildren(node);
    }

    public SchemaNode getSchemaNode() {
        return this.schemaNode;
    }

    public List<RankNode> getChildren() {
        return this.children;
    }

    public Optional<SchemaNode> getProperty() {
        return this.property;
    }

    public RankNodeType getType() {
        return this.type;
    }

    public Optional<SpecificFunction> getFunctionSignature() {
        return this.functionSignature;
    }

    public void setFunctionSignature(SpecificFunction signature) {
        this.functionSignature = Optional.of(signature);
    }

    public SchemaNode getSymbolNode() {
        if (this.type == RankNodeType.EXPRESSION || this.schemaNode.size() == 0) {
            return null;
        }
        SchemaNode symbolNode = this.schemaNode.get(0);
        if (!symbolNode.hasSymbol()) {
            return null;
        }
        return symbolNode;
    }

    public boolean hasSymbol() {
        return this.getSymbolNode() != null;
    }

    public Symbol getSymbol() {
        if (!this.hasSymbol()) {
            return null;
        }
        return this.getSymbolNode().getSymbol();
    }

    public Symbol.SymbolType getSymbolType() {
        return this.getSymbolNode().getSymbol().getType();
    }

    public Symbol.SymbolStatus getSymbolStatus() {
        return this.getSymbolNode().getSymbol().getStatus();
    }

    public Range getRange() {
        return this.schemaNode.getRange();
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }

    private void setInsideLambdaFunction() {
        if (this.insideLambdaFunction) {
            return;
        }
        this.insideLambdaFunction = true;
        for (RankNode child : this.children) {
            child.setInsideLambdaFunction();
        }
    }

    public boolean getInsideLambdaFunction() {
        return this.insideLambdaFunction;
    }

    public boolean getArgumentListExists() {
        return this.arugmentListExists;
    }

    public String toString() {
        return "[RANK: " + this.type + "] " + this.schemaNode.toString() + (String)(this.hasSymbol() ? " Symbol: " + this.getSymbol().toString() : "");
    }

    @Override
    public Iterator<RankNode> iterator() {
        return new Iterator<RankNode>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < RankNode.this.children.size();
            }

            @Override
            public RankNode next() {
                return RankNode.this.children.get(this.currentIndex++);
            }
        };
    }

    public static enum ReturnType {
        INTEGER,
        DOUBLE,
        STRING,
        TENSOR,
        UNKNOWN;

    }

    public static enum RankNodeType {
        FEATURE,
        EXPRESSION,
        BUILT_IN_FUNCTION;

    }
}

