/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.AS;
import ai.vespa.schemals.parser.ast.RootRankProfile;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.parser.ast.fieldOutsideDoc;
import ai.vespa.schemals.parser.ast.functionElm;
import ai.vespa.schemals.parser.ast.identifierStr;
import ai.vespa.schemals.parser.ast.identifierWithDashStr;
import ai.vespa.schemals.parser.ast.importField;
import ai.vespa.schemals.parser.ast.mapDataType;
import ai.vespa.schemals.parser.ast.namedDocument;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.parser.ast.structFieldDefinition;
import ai.vespa.schemals.parser.ast.tensorTypeElm;
import ai.vespa.schemals.parser.rankingexpression.ast.lambdaFunction;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.schema.processing.ReservedFunctionNames;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TensorTypeParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class IdentifySymbolDefinition
extends Identifier {
    private static final Set<String> reservedFunctionNames = ReservedFunctionNames.getReservedNames();

    public IdentifySymbolDefinition(ParseContext context) {
        super(context);
    }

    public ArrayList<Diagnostic> identify(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (node.isASTInstance(dataType.class)) {
            this.handleDataTypeDefinition(node, ret);
            return ret;
        }
        if (node.getLanguageType() == SchemaNode.LanguageType.RANK_EXPRESSION) {
            return this.identifyDefinitionInRankExpression(node);
        }
        boolean isIdentifier = node.isSchemaASTInstance(identifierStr.class);
        boolean isIdentifierWithDash = node.isSchemaASTInstance(identifierWithDashStr.class);
        if (!isIdentifier && !isIdentifierWithDash) {
            return ret;
        }
        SchemaNode parent = node.getParent();
        if (parent == null) {
            return ret;
        }
        if (parent.isASTInstance(importField.class) && node.getPreviousSibling() != null && node.getPreviousSibling().isASTInstance(AS.class)) {
            this.createSymbol(node, Symbol.SymbolType.FIELD);
            return ret;
        }
        if (parent.indexOf(node) >= 3) {
            if (parent.isASTInstance(functionElm.class) && node.isASTInstance(identifierStr.class)) {
                this.createSymbol(node, Symbol.SymbolType.PARAMETER);
            }
            return ret;
        }
        HashMap<Class<?>, Symbol.SymbolType> searchMap = isIdentifier ? SchemaIndex.IDENTIFIER_TYPE_MAP : SchemaIndex.IDENTIFIER_WITH_DASH_TYPE_MAP;
        Symbol.SymbolType symbolType = (Symbol.SymbolType)((Object)searchMap.get(parent.getASTClass()));
        if (symbolType != null) {
            if (parent.isASTInstance(namedDocument.class) || parent.isASTInstance(rootSchema.class)) {
                node.setSymbol(symbolType, this.context.fileURI());
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
                return ret;
            }
            Optional<Symbol> scope = CSTUtils.findScope(node);
            if (scope.isEmpty()) {
                if (symbolType == Symbol.SymbolType.RANK_PROFILE && parent.getParent() != null && parent.getParent().isASTInstance(RootRankProfile.class)) {
                    String workspaceRootURI = this.context.scheduler().getWorkspaceURI();
                    if (workspaceRootURI == null) {
                        return ret;
                    }
                    String currentURI = this.context.fileURI();
                    String schemaName = FileUtils.firstPathComponentAfterPrefix(currentURI, workspaceRootURI);
                    if (schemaName == null) {
                        return ret;
                    }
                    Optional<Symbol> schemaSymbol = this.context.schemaIndex().getSchemaDefinition(schemaName);
                    if (schemaSymbol.isEmpty()) {
                        return ret;
                    }
                    node.setSymbol(symbolType, this.context.fileURI(), schemaSymbol.get());
                    node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                    this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
                }
                return ret;
            }
            node.setSymbol(symbolType, this.context.fileURI(), scope.get());
            Optional<Symbol> existingSymbol = this.context.schemaIndex().findSymbolInScope(node.getSymbol());
            if (existingSymbol.isEmpty()) {
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
                if (node.getSymbol().getType() == Symbol.SymbolType.FUNCTION) {
                    this.verifySymbolFunctionName(node, ret);
                }
            } else {
                node.setSymbolStatus(Symbol.SymbolStatus.INVALID);
                if (symbolType == Symbol.SymbolType.FIELD) {
                    Range range = null;
                    if (parent.getParent().isASTInstance(fieldOutsideDoc.class)) {
                        range = node.getRange();
                    } else if (!this.context.fieldIndex().getIsInsideDoc(existingSymbol.get())) {
                        range = existingSymbol.get().getNode().getRange();
                    }
                    if (range != null) {
                        ret.add(new SchemaDiagnostic.Builder().setRange(range).setMessage("Field '" + node.getText() + "' shadows a document field with the same name.").setSeverity(DiagnosticSeverity.Warning).build());
                    }
                }
            }
            return ret;
        }
        return ret;
    }

    private void handleDataTypeDefinition(SchemaNode node, List<Diagnostic> diagnostics) {
        Optional<Symbol> scope;
        if (node.getParent() == null) {
            return;
        }
        if (node.getParent().isASTInstance(mapDataType.class)) {
            scope = this.findMapScope(node.getParent());
            if (!scope.isPresent()) {
                return;
            }
            if (node.getParent().indexOf(node) == 2) {
                node.setSymbol(Symbol.SymbolType.MAP_KEY, this.context.fileURI(), scope.get(), "key");
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            } else if (node.getParent().indexOf(node) == 4) {
                dataType dataTypeNode = (dataType)node.getOriginalSchemaNode();
                if (dataTypeNode.getParsedType().getVariant() == ParsedType.Variant.UNKNOWN) {
                    return;
                }
                node.setSymbol(Symbol.SymbolType.MAP_VALUE, this.context.fileURI(), scope.get(), "value");
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            }
        }
        if (node.isASTInstance(tensorTypeElm.class)) {
            scope = CSTUtils.findScope(node);
            if (!scope.isPresent()) {
                return;
            }
            try {
                TensorType tensorType2 = TensorTypeParser.fromSpec((String)node.getText());
                node.setSymbol(Symbol.SymbolType.TENSOR, this.context.fileURI(), scope.get());
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
                for (TensorType.Dimension dimension : tensorType2.dimensions()) {
                    Symbol.SymbolType type = dimension instanceof TensorType.MappedDimension ? Symbol.SymbolType.TENSOR_DIMENSION_MAPPED : Symbol.SymbolType.TENSOR_DIMENSION_INDEXED;
                    Symbol dimensionSymbol = new Symbol(node, type, this.context.fileURI(), node.getSymbol(), dimension.name());
                    dimensionSymbol.setStatus(Symbol.SymbolStatus.DEFINITION);
                    this.context.schemaIndex().insertSymbolDefinition(dimensionSymbol);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Optional<Symbol> findMapScope(SchemaNode mapDataTypeNode) {
        while (mapDataTypeNode != null) {
            if ((mapDataTypeNode = mapDataTypeNode.getParent()) == null) {
                return Optional.empty();
            }
            if (mapDataTypeNode.hasSymbol()) {
                return Optional.of(mapDataTypeNode.getSymbol());
            }
            if (!mapDataTypeNode.isASTInstance(fieldElm.class) && !mapDataTypeNode.isASTInstance(structFieldDefinition.class)) continue;
            SchemaNode fieldIdentifierNode = mapDataTypeNode.get(1);
            if (fieldIdentifierNode == null) {
                return Optional.empty();
            }
            if (!fieldIdentifierNode.hasSymbol() || fieldIdentifierNode.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) {
                return Optional.empty();
            }
            return Optional.of(fieldIdentifierNode.getSymbol());
        }
        return Optional.empty();
    }

    private void createSymbol(SchemaNode node, Symbol.SymbolType type) {
        Optional<Symbol> scope = CSTUtils.findScope(node);
        if (scope.isPresent()) {
            node.setSymbol(type, this.context.fileURI(), scope.get());
        } else {
            node.setSymbol(type, this.context.fileURI());
        }
        node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
        this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
    }

    private ArrayList<Diagnostic> identifyDefinitionInRankExpression(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (!node.isASTInstance(ai.vespa.schemals.parser.rankingexpression.ast.identifierStr.class)) {
            return ret;
        }
        SchemaNode grandParent = node.getParent(2);
        if (grandParent == null || !grandParent.isASTInstance(lambdaFunction.class) || grandParent.size() < 1) {
            return ret;
        }
        SchemaNode parent = grandParent.get(0);
        if (!parent.hasSymbol()) {
            Optional<Symbol> parentScope = CSTUtils.findScope(parent);
            if (parentScope.isEmpty()) {
                return ret;
            }
            parent.setSymbol(Symbol.SymbolType.LAMBDA_FUNCTION, this.context.fileURI(), parentScope.get(), "lambda_" + node.hashCode());
            parent.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(parent.getSymbol());
        }
        node.setSymbol(Symbol.SymbolType.PARAMETER, this.context.fileURI(), parent.getSymbol());
        if (this.context.schemaIndex().findSymbolsInScope(node.getSymbol()).size() == 0) {
            node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
        } else {
            node.setSymbolStatus(Symbol.SymbolStatus.INVALID);
        }
        return ret;
    }

    private void verifySymbolFunctionName(SchemaNode node, List<Diagnostic> diagnostics) {
        String functionName = node.getSymbol().getShortIdentifier();
        if (reservedFunctionNames.contains(functionName)) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Function '" + node.getText() + "' has a reserved name. This might mean that the function shadows the built-in function with the same name.").setSeverity(DiagnosticSeverity.Warning).build());
        }
    }
}

