/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.parser.ast.documentElm;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.parser.ast.rootSchemaItem;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class IdentifyDocumentlessSchema
extends Identifier {
    public IdentifyDocumentlessSchema(ParseContext context) {
        super(context);
    }

    public ArrayList<Diagnostic> identify(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (!node.isSchemaASTInstance(rootSchema.class)) {
            return ret;
        }
        if (node.size() < 2 || node.get(1).getIsDirty()) {
            return ret;
        }
        for (SchemaNode child : node) {
            if (!child.isSchemaASTInstance(rootSchemaItem.class) || child.size() == 0 || !child.get(0).isSchemaASTInstance(documentElm.class)) continue;
            return ret;
        }
        ret.add(new SchemaDiagnostic.Builder().setRange(node.get(0).getRange()).setMessage("Missing mandatory document definition in schema body.").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.DOCUMENTLESS_SCHEMA).build());
        return ret;
    }
}

