/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.semantictokens;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.context.EventDocumentContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.semantictokens.SemanticTokenConfig;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.TokenSource;
import ai.vespa.schemals.parser.ast.FILTER;
import ai.vespa.schemals.parser.ast.RANK_TYPE;
import ai.vespa.schemals.parser.ast.bool;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.fieldRankType;
import ai.vespa.schemals.parser.ast.integerElm;
import ai.vespa.schemals.parser.ast.matchItem;
import ai.vespa.schemals.parser.ast.matchType;
import ai.vespa.schemals.parser.ast.quotedString;
import ai.vespa.schemals.parser.ast.rankSettingElm;
import ai.vespa.schemals.parser.ast.rankTypeElm;
import ai.vespa.schemals.parser.ast.summaryItem;
import ai.vespa.schemals.parser.ast.valueType;
import ai.vespa.schemals.parser.indexinglanguage.Token;
import ai.vespa.schemals.parser.rankingexpression.Token;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensServerFull;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;

public class SchemaSemanticTokens {
    private static Map<Symbol.SymbolType, Integer> identifierTypeMap;
    private static ArrayList<String> tokenTypes;
    private static Map<Token.TokenType, Integer> schemaTokenTypeMap;
    private static Map<Token.TokenType, Integer> rankExpressionTokenTypeMap;
    private static final Set<Class<?>> enumLikeItems;

    private static int addTokenType(String name) {
        int index = tokenTypes.indexOf(name);
        if (index == -1) {
            index = tokenTypes.size();
            tokenTypes.add(name);
        }
        return index;
    }

    public static SemanticTokensWithRegistrationOptions getSemanticTokensRegistrationOptions() {
        return new SemanticTokensWithRegistrationOptions(new SemanticTokensLegend(tokenTypes, SemanticTokenConfig.tokenModifiers), new SemanticTokensServerFull(Boolean.valueOf(false)));
    }

    private static ArrayList<SemanticTokenMarker> traverseCST(SchemaNode node, ClientLogger logger) {
        ArrayList<SemanticTokenMarker> ret;
        block7: {
            block12: {
                Token.TokenType indexinglanguageType;
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                Token.TokenType rankExpressionType;
                                block10: {
                                    Token.TokenType schemaType;
                                    block9: {
                                        block8: {
                                            block6: {
                                                ret = new ArrayList<SemanticTokenMarker>();
                                                schemaType = node.getSchemaType();
                                                rankExpressionType = node.getRankExpressionType();
                                                indexinglanguageType = node.getIndexingLanguageType();
                                                if (!node.isASTInstance(dataType.class) || node.hasSymbol() && node.getSymbol().getType() != Symbol.SymbolType.MAP_KEY && node.getSymbol().getType() != Symbol.SymbolType.MAP_VALUE) break block6;
                                                Integer tokenType = tokenTypes.indexOf("type");
                                                if (tokenType != -1) {
                                                    Range markerRange = CSTUtils.findFirstLeafChild(node).getRange();
                                                    ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                                                }
                                                for (SchemaNode child : node) {
                                                    ArrayList<SemanticTokenMarker> markers = SchemaSemanticTokens.traverseCST(child, logger);
                                                    ret.addAll(markers);
                                                }
                                                break block7;
                                            }
                                            if (!node.isASTInstance(valueType.class)) break block8;
                                            Integer tokenType = tokenTypes.indexOf("type");
                                            if (tokenType == -1) break block7;
                                            ret.add(new SemanticTokenMarker((int)tokenType, node));
                                            break block7;
                                        }
                                        if (!node.hasSymbol()) break block9;
                                        ret.addAll(SchemaSemanticTokens.findSemanticMarkersForSymbol(node));
                                        break block7;
                                    }
                                    if (schemaType == null) break block10;
                                    Integer tokenType = null;
                                    String modifier = null;
                                    if (SchemaSemanticTokens.isEnumLike(node)) {
                                        tokenType = tokenTypes.indexOf("property");
                                        modifier = "readonly";
                                    }
                                    if (tokenType == null) {
                                        tokenType = schemaTokenTypeMap.get(schemaType);
                                    }
                                    if (tokenType == null) break block7;
                                    SemanticTokenMarker marker = new SemanticTokenMarker((int)tokenType, node);
                                    if (modifier != null) {
                                        marker.addModifier(modifier);
                                    }
                                    ret.add(marker);
                                    break block7;
                                }
                                if (rankExpressionType == null) break block11;
                                Integer tokenType = rankExpressionTokenTypeMap.get(rankExpressionType);
                                if (tokenType == null) break block7;
                                ret.add(new SemanticTokenMarker((int)tokenType, node));
                                break block7;
                            }
                            if (indexinglanguageType == null) break block12;
                            if (!SemanticTokenConfig.indexingLanguageOutputs.contains(indexinglanguageType)) break block13;
                            Integer tokenType = tokenTypes.indexOf("type");
                            Range markerRange = CSTUtils.findFirstLeafChild(node).getRange();
                            ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                            break block7;
                        }
                        if (!SemanticTokenConfig.indexingLanguageKeywords.contains(indexinglanguageType)) break block14;
                        Integer tokenType = tokenTypes.indexOf("keyword");
                        Range markerRange = CSTUtils.findFirstLeafChild(node).getRange();
                        ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                        break block7;
                    }
                    if (!SemanticTokenConfig.indexingLanguageOperators.contains(indexinglanguageType)) break block15;
                    Integer tokenType = tokenTypes.indexOf("function");
                    Range markerRange = CSTUtils.findFirstLeafChild(node).getRange();
                    ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                    break block7;
                }
                if (indexinglanguageType != Token.TokenType.STRING) break block7;
                Integer tokenType = tokenTypes.indexOf("string");
                Range markerRange = CSTUtils.findFirstLeafChild(node).getRange();
                ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                break block7;
            }
            for (SchemaNode child : node) {
                ArrayList<SemanticTokenMarker> markers = SchemaSemanticTokens.traverseCST(child, logger);
                ret.addAll(markers);
            }
        }
        return ret;
    }

    private static boolean isEnumLike(SchemaNode node) {
        SchemaNode it;
        if (node.getLanguageType() != SchemaNode.LanguageType.SCHEMA) {
            return false;
        }
        if (node.getParent() == null) {
            return false;
        }
        if (node.getParent().isASTInstance(integerElm.class) || node.getParent().isASTInstance(quotedString.class) || node.getParent().isASTInstance(bool.class)) {
            return false;
        }
        if (!node.isLeaf()) {
            return false;
        }
        if (node.isASTInstance(FILTER.class)) {
            return true;
        }
        if (node.isASTInstance(RANK_TYPE.class)) {
            return false;
        }
        for (it = node.getParent(); it != null && !enumLikeItems.contains(it.getASTClass()); it = it.getParent()) {
        }
        if (it == null) {
            return false;
        }
        return node.getParent().indexOf(node) == 0;
    }

    private static List<SemanticTokenMarker> findSemanticMarkersForSymbol(SchemaNode node) {
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        if (!node.hasSymbol()) {
            return ret;
        }
        if (SemanticTokenConfig.userDefinedSymbolTypes.contains((Object)node.getSymbol().getType()) && (node.getSymbol().getStatus() == Symbol.SymbolStatus.REFERENCE || node.getSymbol().getStatus() == Symbol.SymbolStatus.DEFINITION)) {
            Integer tokenType = identifierTypeMap.get((Object)node.getSymbol().getType());
            if (tokenType != null) {
                SemanticTokenMarker tokenMarker = new SemanticTokenMarker((int)tokenType, node);
                if (node.getSymbol().getStatus() == Symbol.SymbolStatus.DEFINITION) {
                    tokenMarker.addModifier("definition");
                }
                ret.add(tokenMarker);
            }
        } else if (node.hasSymbol() && node.getSymbol().getStatus() == Symbol.SymbolStatus.BUILTIN_REFERENCE) {
            Symbol.SymbolType type = node.getSymbol().getType();
            Integer tokenType = identifierTypeMap.get((Object)type);
            if (type == Symbol.SymbolType.FUNCTION && node.getLanguageType() == SchemaNode.LanguageType.RANK_EXPRESSION) {
                tokenType = tokenTypes.indexOf("macro");
            }
            if (tokenType != null && tokenType != -1) {
                SemanticTokenMarker tokenMarker = new SemanticTokenMarker((int)tokenType, node);
                tokenMarker.addModifier("defaultLibrary");
                ret.add(tokenMarker);
            }
        }
        return ret;
    }

    private static ArrayList<SemanticTokenMarker> convertCommentRanges(ArrayList<Range> comments) {
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        int tokenType = tokenTypes.indexOf("comment");
        for (Range range : comments) {
            ret.add(new SemanticTokenMarker(tokenType, range));
        }
        return ret;
    }

    private static ArrayList<SemanticTokenMarker> findComments(SchemaNode rootNode) {
        TokenSource tokenSource = rootNode.getTokenSource();
        String source = tokenSource.toString();
        ArrayList<Range> ret = new ArrayList<Range>();
        int index = source.indexOf("#");
        while (index >= 0) {
            Position start = CSTUtils.getPositionFromOffset(tokenSource, index);
            if (CSTUtils.getLeafNodeAtPosition(rootNode, start) != null) {
                index = source.indexOf("#", index + 1);
                continue;
            }
            if ((index = source.indexOf("\n", index + 1)) < 0) {
                index = source.length() - 1;
            }
            Position end = CSTUtils.getPositionFromOffset(tokenSource, index);
            ret.add(new Range(start, end));
            index = source.indexOf("#", index + 1);
        }
        return SchemaSemanticTokens.convertCommentRanges(ret);
    }

    private static ArrayList<SemanticTokenMarker> mergeSemanticTokenMarkers(ArrayList<SemanticTokenMarker> lhs, ArrayList<SemanticTokenMarker> rhs) {
        int i;
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>(lhs.size() + rhs.size());
        int lhsIndex = 0;
        int rhsIndex = 0;
        while (lhsIndex < lhs.size() && rhsIndex < rhs.size()) {
            Position rhsPos = rhs.get(rhsIndex).getRange().getStart();
            Position lhsPos = lhs.get(lhsIndex).getRange().getStart();
            if (CSTUtils.positionLT(lhsPos, rhsPos)) {
                ret.add(lhs.get(lhsIndex));
                ++lhsIndex;
                continue;
            }
            ret.add(rhs.get(rhsIndex));
            ++rhsIndex;
        }
        for (i = lhsIndex; i < lhs.size(); ++i) {
            ret.add(lhs.get(i));
        }
        for (i = rhsIndex; i < rhs.size(); ++i) {
            ret.add(rhs.get(i));
        }
        return ret;
    }

    public static SemanticTokens getSemanticTokens(EventDocumentContext context) {
        if (context.document == null) {
            return new SemanticTokens(new ArrayList());
        }
        SchemaNode node = context.document.getRootNode();
        if (node == null) {
            return new SemanticTokens(new ArrayList());
        }
        ArrayList<SemanticTokenMarker> comments = SchemaSemanticTokens.findComments(context.document.getRootNode());
        ArrayList<SemanticTokenMarker> markers = SchemaSemanticTokens.traverseCST(node, context.logger);
        ArrayList<Integer> compactMarkers = SemanticTokenMarker.concatCompactForm(SchemaSemanticTokens.mergeSemanticTokenMarkers(markers, comments));
        return new SemanticTokens(compactMarkers);
    }

    static {
        int index;
        tokenTypes = new ArrayList();
        tokenTypes.addAll(SemanticTokenConfig.manuallyRegisteredLSPNames);
        int keywordIndex = SchemaSemanticTokens.addTokenType("keyword");
        identifierTypeMap = new HashMap<Symbol.SymbolType, Integer>();
        for (Map.Entry<Symbol.SymbolType, String> entry : SemanticTokenConfig.identifierTypeLSPNameMap.entrySet()) {
            index = SchemaSemanticTokens.addTokenType(entry.getValue());
            identifierTypeMap.put(entry.getKey(), index);
        }
        schemaTokenTypeMap = new HashMap<Token.TokenType, Integer>();
        for (Map.Entry<Enum, String> entry : SemanticTokenConfig.schemaTokenTypeLSPNameMap.entrySet()) {
            index = SchemaSemanticTokens.addTokenType(entry.getValue());
            schemaTokenTypeMap.put((Token.TokenType)entry.getKey(), index);
        }
        for (Token.TokenType tokenType : SemanticTokenConfig.keywordTokens) {
            schemaTokenTypeMap.put(tokenType, keywordIndex);
        }
        rankExpressionTokenTypeMap = new HashMap<Token.TokenType, Integer>();
        for (Map.Entry entry : SemanticTokenConfig.rankingExpressionTokenTypeLSPNameMap.entrySet()) {
            index = SchemaSemanticTokens.addTokenType((String)entry.getValue());
            rankExpressionTokenTypeMap.put((Token.TokenType)entry.getKey(), index);
        }
        for (Token.TokenType tokenType : SemanticTokenConfig.rankingExpressionKeywordTokens) {
            rankExpressionTokenTypeMap.put(tokenType, keywordIndex);
        }
        int operationIndex = SchemaSemanticTokens.addTokenType("operator");
        for (Token.TokenType type : SemanticTokenConfig.rankingExpressionOperationTokens) {
            rankExpressionTokenTypeMap.put(type, operationIndex);
        }
        int n = SchemaSemanticTokens.addTokenType("function");
        for (Token.TokenType type : SemanticTokenConfig.rankingExpressioFunctionTokens) {
            rankExpressionTokenTypeMap.put(type, n);
        }
        enumLikeItems = new HashSet<Class<?>>(){
            {
                this.add(matchType.class);
                this.add(matchItem.class);
                this.add(rankSettingElm.class);
                this.add(fieldRankType.class);
                this.add(rankTypeElm.class);
                this.add(summaryItem.class);
            }
        };
    }

    private static class SemanticTokenMarker {
        private static final int LINE_INDEX = 0;
        private static final int COLUMN_INDEX = 1;
        private int tokenType;
        private int modifierValue = 0;
        private Range range;

        SemanticTokenMarker(int tokenType, SchemaNode node) {
            this(tokenType, node.getRange());
        }

        SemanticTokenMarker(int tokenType, Range range) {
            this.tokenType = tokenType;
            this.range = range;
        }

        Range getRange() {
            return this.range;
        }

        void addModifier(String modifier) {
            int modifierIndex = SemanticTokenConfig.tokenModifiers.indexOf(modifier);
            if (modifierIndex == -1) {
                throw new IllegalArgumentException("Could not find the semantic token modifier '" + modifier + "'. Remeber to add the modifer to the tokenModifiers list.");
            }
            int bitMask = 1 << modifierIndex;
            this.modifierValue |= bitMask;
        }

        private ArrayList<Integer> compactForm() {
            final int length = this.range.getEnd().getCharacter() - this.range.getStart().getCharacter();
            return new ArrayList<Integer>(){
                {
                    this.add(range.getStart().getLine());
                    this.add(range.getStart().getCharacter());
                    this.add(length);
                    this.add(tokenType);
                    this.add(modifierValue);
                }
            };
        }

        static ArrayList<Integer> concatCompactForm(ArrayList<SemanticTokenMarker> markers) {
            ArrayList<Integer> ret = new ArrayList<Integer>(markers.size() * 5);
            if (markers.size() == 0) {
                return ret;
            }
            ret.addAll(markers.get(0).compactForm());
            for (int i = 1; i < markers.size(); ++i) {
                ArrayList<Integer> markerCompact = markers.get(i).compactForm();
                ArrayList<Integer> lastMarkerCompact = markers.get(i - 1).compactForm();
                markerCompact.set(0, markerCompact.get(0) - lastMarkerCompact.get(0));
                if (markerCompact.get(0) == 0) {
                    markerCompact.set(1, markerCompact.get(1) - lastMarkerCompact.get(1));
                }
                ret.addAll(markerCompact);
            }
            return ret;
        }
    }
}

