/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.index;

import ai.vespa.schemals.common.ClientLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InheritanceGraph<NodeType> {
    protected Map<NodeType, List<NodeType>> parentsOfNode = new HashMap<NodeType, List<NodeType>>();
    protected Map<NodeType, List<NodeType>> childrenOfNode = new HashMap<NodeType, List<NodeType>>();

    public void clearInheritsList(NodeType node) {
        if (!this.nodeExists(node)) {
            return;
        }
        for (NodeType parent : this.parentsOfNode.get(node)) {
            if (!this.childrenOfNode.containsKey(parent)) continue;
            this.childrenOfNode.get(parent).remove(node);
        }
        this.parentsOfNode.remove(node);
        this.childrenOfNode.remove(node);
    }

    public void createNodeIfNotExists(NodeType node) {
        if (!this.parentsOfNode.containsKey(node)) {
            this.parentsOfNode.put(node, new ArrayList());
        }
        if (!this.childrenOfNode.containsKey(node)) {
            this.childrenOfNode.put(node, new ArrayList());
        }
    }

    public boolean addInherits(NodeType childNode, NodeType parentNode) {
        List<NodeType> parentChildren;
        this.createNodeIfNotExists(childNode);
        this.createNodeIfNotExists(parentNode);
        List<NodeType> existingAncestors = this.getAllAncestors(parentNode);
        if (existingAncestors.contains(childNode)) {
            return false;
        }
        List<NodeType> parentList = this.parentsOfNode.get(childNode);
        if (!parentList.contains(parentNode)) {
            parentList.add(parentNode);
        }
        if (!(parentChildren = this.childrenOfNode.get(parentNode)).contains(childNode)) {
            parentChildren.add(childNode);
        }
        return true;
    }

    public List<NodeType> getAllParents(NodeType node) {
        this.createNodeIfNotExists(node);
        return this.parentsOfNode.get(node);
    }

    public List<NodeType> getAllAncestors(NodeType node) {
        this.createNodeIfNotExists(node);
        ArrayList result = new ArrayList();
        HashSet visited = new HashSet();
        this.getAllAncestorsImpl(node, result, visited);
        return result;
    }

    public List<NodeType> getAllDescendants(NodeType node) {
        this.createNodeIfNotExists(node);
        ArrayList result = new ArrayList();
        HashSet visited = new HashSet();
        this.getAllDescendantsImpl(node, result, visited);
        return result;
    }

    public List<NodeType> getTopoOrdering() {
        HashSet visited = new HashSet();
        LinkedList result = new LinkedList();
        for (NodeType node : this.parentsOfNode.keySet()) {
            if (visited.contains(node)) continue;
            this.getAllAncestorsImpl(node, result, visited);
        }
        return result;
    }

    public <T> List<SearchResult<T>> findFirstMatches(NodeType node, Function<NodeType, T> predicate) {
        this.createNodeIfNotExists(node);
        HashSet visited = new HashSet();
        ArrayList<SearchResult<T>> result = new ArrayList<SearchResult<T>>();
        this.findFirstMatchesImpl(node, result, visited, predicate);
        return result;
    }

    private <T> void findFirstMatchesImpl(NodeType node, List<SearchResult<T>> result, Set<NodeType> visited, Function<NodeType, T> predicate) {
        if (!this.parentsOfNode.containsKey(node)) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        T match = predicate.apply(node);
        if (match != null) {
            result.add(new SearchResult<T>(node, match));
            return;
        }
        for (NodeType parent : this.parentsOfNode.get(node)) {
            this.findFirstMatchesImpl(parent, result, visited, predicate);
        }
    }

    private void getAllAncestorsImpl(NodeType node, List<NodeType> result, Set<NodeType> visited) {
        if (!this.parentsOfNode.containsKey(node)) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        for (NodeType parentNode : this.parentsOfNode.get(node)) {
            this.getAllAncestorsImpl(parentNode, result, visited);
        }
        result.add(node);
    }

    private void getAllDescendantsImpl(NodeType node, List<NodeType> result, Set<NodeType> visited) {
        if (!this.childrenOfNode.containsKey(node)) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        result.add(node);
        for (NodeType childNode : this.getValidChildren(node)) {
            this.getAllDescendantsImpl(childNode, result, visited);
        }
    }

    private boolean nodeExists(NodeType node) {
        return this.parentsOfNode.containsKey(node) && this.childrenOfNode.containsKey(node);
    }

    private List<NodeType> getValidChildren(NodeType node) {
        return ((List)this.childrenOfNode.getOrDefault(node, new ArrayList())).stream().filter(childNode -> this.parentsOfNode.get(childNode).contains(node)).collect(Collectors.toList());
    }

    public void dumpAllEdges(ClientLogger logger) {
        for (Map.Entry<NodeType, List<NodeType>> entry : this.parentsOfNode.entrySet()) {
            NodeType node = entry.getKey();
            logger.info(node.toString() + " inherits from:");
            for (NodeType parent : entry.getValue()) {
                logger.info("    " + parent.toString());
            }
        }
        for (Map.Entry<Object, List<Object>> parentURI : this.childrenOfNode.keySet()) {
            logger.info(parentURI.toString() + " has children:");
            for (Map.Entry<Object, List<Object>> childURI : this.getValidChildren(parentURI)) {
                logger.info("    " + childURI.toString());
            }
        }
    }

    public class SearchResult<ResultType> {
        public NodeType node = null;
        public ResultType result = null;

        public SearchResult(NodeType node, ResultType result) {
            this.node = node;
            this.result = result;
        }
    }
}

