/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.common;

import ai.vespa.schemals.tree.SchemaNode;
import java.util.List;
import org.eclipse.lsp4j.Position;

public class StringUtils {
    public static final int TAB_SIZE = 4;

    public static int positionToOffset(String content, Position pos) {
        List<String> lines = content.lines().toList();
        if (pos.getLine() >= lines.size()) {
            throw new IllegalArgumentException("Line " + pos.getLine() + " out of range.");
        }
        int lineCounter = 0;
        int offset = 0;
        for (String line : lines) {
            if (lineCounter == pos.getLine()) break;
            offset += line.length() + 1;
            ++lineCounter;
        }
        if (pos.getCharacter() > lines.get(pos.getLine()).length()) {
            throw new IllegalArgumentException("Character " + pos.getCharacter() + " out of range for line " + pos.getLine());
        }
        return offset += pos.getCharacter();
    }

    public static Position offsetToPosition(String content, int offset) {
        List<String> lines = content.lines().toList();
        int lineCounter = 0;
        for (String line : lines) {
            int lengthIncludingTerminator = line.length() + 1;
            if (offset < lengthIncludingTerminator) {
                return new Position(lineCounter, offset);
            }
            offset -= lengthIncludingTerminator;
            ++lineCounter;
        }
        return null;
    }

    public static Position positionAddOffset(String content, Position pos, int offset) {
        int totalOffset = StringUtils.positionToOffset(content, pos) + offset;
        return StringUtils.offsetToPosition(content, totalOffset);
    }

    public static String getIndentString(String content, SchemaNode node) {
        int offset = node.getOriginalBeginOffset();
        int nl = content.lastIndexOf(10, offset) + 1;
        return content.substring(nl, offset);
    }

    public static int countSpaceIndents(String indentString) {
        if (indentString.isEmpty()) {
            return 0;
        }
        if (indentString.charAt(0) == '\t') {
            return indentString.length() * 4;
        }
        return indentString.length();
    }

    public static String spaceIndent(int indent) {
        return new String(new char[indent]).replace("\u0000", " ");
    }

    public static String addIndents(String text, int indentDelta) {
        if (indentDelta == 0) {
            return text;
        }
        if (indentDelta > 0) {
            return text.replace("\n", "\n" + StringUtils.spaceIndent(indentDelta));
        }
        return text.replace("\n" + StringUtils.spaceIndent(-indentDelta), "\n");
    }

    public static Position getPreviousStartOfWord(String content, Position pos) {
        try {
            for (int offset = StringUtils.positionToOffset(content, pos) - 1; offset >= 0 && Character.isWhitespace(content.charAt(offset)) && content.charAt(offset) != '\n'; --offset) {
            }
            for (int i = offset; i >= 0; --i) {
                if (!Character.isWhitespace(content.charAt(i))) continue;
                return StringUtils.offsetToPosition(content, i + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isInsideComment(String content, Position pos) {
        try {
            int offset = StringUtils.positionToOffset(content, pos);
            if (content.charAt(offset) == '\n') {
                --offset;
            }
            for (int i = offset; i >= 0 && content.charAt(i) != '\n'; --i) {
                if (content.charAt(i) != '#') continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

