/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;

public class KeywordArgument
implements Argument {
    private String argument;
    private String displayStr;

    public KeywordArgument(String argument, String displayStr) {
        this.argument = argument;
        this.displayStr = displayStr;
    }

    public KeywordArgument(String argument) {
        this(argument, argument);
    }

    @Override
    public String displayString() {
        return this.displayStr;
    }

    public String getArgument() {
        return this.argument;
    }

    @Override
    public int getStrictness() {
        return 8;
    }

    @Override
    public boolean validateArgument(RankNode node) {
        return node.getSchemaNode().getText().equals(this.argument);
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        if (!this.validateArgument(node)) {
            return Optional.empty();
        }
        RankNode leaf = node;
        while (leaf.getChildren().size() > 0) {
            leaf = leaf.getChildren().get(0);
        }
        Symbol symbol = leaf.getSymbol();
        if (symbol == null) {
            return Optional.empty();
        }
        if (symbol.getStatus() == Symbol.SymbolStatus.REFERENCE) {
            context.schemaIndex().deleteSymbolReference(symbol);
        }
        symbol.setType(Symbol.SymbolType.DIMENSION);
        symbol.setStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
        return Optional.empty();
    }
}

