/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Diagnostic;

public class FunctionSignature {
    private List<Argument> argumentList;
    private Set<String> properties;
    private boolean expandable = false;

    public FunctionSignature(List<Argument> arguments, Set<String> properties, boolean expandable) {
        this.argumentList = arguments;
        this.properties = properties;
        this.expandable = expandable;
        if (expandable && arguments.size() <= 0) {
            throw new IllegalArgumentException("An expandable function takes at least one argument");
        }
    }

    public FunctionSignature(List<Argument> argument, Set<String> properties) {
        this(argument, properties, false);
    }

    public FunctionSignature(List<Argument> arguments, boolean expandable) {
        this(arguments, new HashSet<String>(), expandable);
    }

    public FunctionSignature(List<Argument> arguments) {
        this(arguments, new HashSet<String>());
    }

    public FunctionSignature(final Argument argument, Set<String> properties) {
        this((List<Argument>)new ArrayList<Argument>(){
            {
                this.add(argument);
            }
        }, properties);
    }

    public FunctionSignature(Argument argument, final String property) {
        this(argument, (Set<String>)new HashSet<String>(){
            {
                this.add(property);
            }
        });
    }

    public FunctionSignature(final Argument argument, boolean expandable) {
        this((List<Argument>)new ArrayList<Argument>(){
            {
                this.add(argument);
            }
        }, new HashSet<String>(), expandable);
    }

    public FunctionSignature(final Argument argument) {
        this((List<Argument>)new ArrayList<Argument>(){
            {
                this.add(argument);
            }
        });
    }

    public FunctionSignature() {
        this(new ArrayList<Argument>());
    }

    int matchScore(List<RankNode> arguments) {
        if (!this.expandable && arguments.size() != this.argumentList.size()) {
            return 0;
        }
        if (this.argumentList.size() == 0) {
            return 1;
        }
        int score = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            int j = Math.min(i, this.argumentList.size() - 1);
            boolean valid = this.argumentList.get(j).validateArgument(arguments.get(i));
            if (!valid) continue;
            score += this.argumentList.get(j).getStrictness();
        }
        return score;
    }

    public List<Argument> getArgumentList() {
        return List.copyOf(this.argumentList);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    List<Diagnostic> handleArgumentList(ParseContext context, List<RankNode> arguments) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (int i = 0; i < arguments.size(); ++i) {
            int j = Math.min(i, this.argumentList.size() - 1);
            Optional<Diagnostic> diagnostic = this.argumentList.get(j).parseArgument(context, arguments.get(i));
            if (!diagnostic.isPresent()) continue;
            diagnostics.add(diagnostic.get());
        }
        return diagnostics;
    }

    public String toString() {
        List argumentListStrings = this.argumentList.stream().map(arg -> arg.displayString()).collect(Collectors.toList());
        Object arguments = String.join((CharSequence)",", argumentListStrings);
        if (this.expandable) {
            arguments = (String)arguments + ",...";
        }
        return "(" + (String)arguments + ")";
    }
}

