/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.completion.provider;

import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.completion.provider.CompletionProvider;
import ai.vespa.schemals.lsp.completion.utils.CompletionUtils;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.ast.identifierStr;
import ai.vespa.schemals.parser.ast.identifierWithDashStr;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.schemadocument.SchemaDocumentLexer;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;

public class InheritsCompletion
implements CompletionProvider {
    private Optional<SchemaNode> match(EventCompletionContext context) {
        SchemaDocumentLexer lexer = context.document.lexer();
        SchemaNode match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.INHERITS);
        if (match != null) {
            return Optional.empty();
        }
        match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.DOCUMENT, Token.TokenType.IDENTIFIER);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return Optional.of(match);
        }
        match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.SCHEMA, Token.TokenType.IDENTIFIER);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return Optional.of(match);
        }
        match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.STRUCT, Token.TokenType.IDENTIFIER);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return Optional.of(match);
        }
        match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.ANNOTATION, Token.TokenType.IDENTIFIER);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return Optional.of(match);
        }
        match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.RANK_PROFILE, Token.TokenType.IDENTIFIER);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return Optional.of(match);
        }
        return Optional.empty();
    }

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        Optional<Symbol> scope;
        String myIdentifierString;
        Symbol.SymbolType equivalentSymbolType;
        Optional<SchemaNode> matched = this.match(context);
        if (matched.isEmpty()) {
            return List.of();
        }
        List<String> suggestions = new ArrayList();
        Token.TokenType nodeType = matched.get().getDirtyType();
        switch (nodeType) {
            case DOCUMENT: {
                equivalentSymbolType = Symbol.SymbolType.DOCUMENT;
                break;
            }
            case SCHEMA: {
                equivalentSymbolType = Symbol.SymbolType.SCHEMA;
                break;
            }
            case RANK_PROFILE: {
                equivalentSymbolType = Symbol.SymbolType.RANK_PROFILE;
                break;
            }
            case STRUCT: {
                equivalentSymbolType = Symbol.SymbolType.STRUCT;
                break;
            }
            case ANNOTATION: {
                equivalentSymbolType = Symbol.SymbolType.ANNOTATION;
                break;
            }
            default: {
                return List.of();
            }
        }
        String string = myIdentifierString = matched.get().getNextSibling() != null && (matched.get().getNextSibling().isASTInstance(identifierStr.class) || matched.get().getNextSibling().isASTInstance(identifierWithDashStr.class)) ? matched.get().getNextSibling().getText() : "";
        if (nodeType == Token.TokenType.DOCUMENT || nodeType == Token.TokenType.RANK_PROFILE || nodeType == Token.TokenType.SCHEMA) {
            suggestions = context.schemaIndex.listSymbolsInScope(null, equivalentSymbolType).stream().map(symbol -> symbol.getShortIdentifier()).filter(str -> !str.equals(myIdentifierString)).collect(Collectors.toCollection(ArrayList::new));
        } else if ((nodeType == Token.TokenType.STRUCT || nodeType == Token.TokenType.ANNOTATION) && (scope = context.schemaIndex.findSymbol(null, Symbol.SymbolType.DOCUMENT, ((SchemaDocument)context.document).getSchemaIdentifier())).isPresent()) {
            suggestions = context.schemaIndex.listSymbolsInScope(scope.get(), equivalentSymbolType).stream().map(symbol -> symbol.getShortIdentifier()).filter(str -> !str.equals(myIdentifierString)).collect(Collectors.toCollection(ArrayList::new));
        }
        if (nodeType == Token.TokenType.RANK_PROFILE && !suggestions.contains("default")) {
            suggestions.add("default");
        }
        if (suggestions.isEmpty()) {
            return List.of(CompletionUtils.constructSnippet("inherits", "inherits $0 "));
        }
        String choiceString = "${1|" + String.join((CharSequence)",", suggestions) + "|}";
        return List.of(CompletionUtils.constructSnippet("inherits", "inherits " + choiceString));
    }
}

