/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.hover;

import ai.vespa.schemals.context.EventPositionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.indexinglanguage.ast.ATTRIBUTE;
import ai.vespa.schemals.parser.indexinglanguage.ast.INDEX;
import ai.vespa.schemals.parser.indexinglanguage.ast.SUMMARY;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.SpecificFunction;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SchemaHover {
    private static final String markdownPathRoot = "hover/";
    private static Map<String, Optional<MarkupContent>> markdownContentCache = new HashMap<String, Optional<MarkupContent>>();

    private static Optional<String> getCommentOnLine(String documentContent, int lineEndOffset) {
        int prevLine = documentContent.lastIndexOf("\n", lineEndOffset - 1);
        String possibleCommentString = documentContent.substring(prevLine + 1, lineEndOffset).trim();
        if (!possibleCommentString.startsWith("#")) {
            return Optional.empty();
        }
        return Optional.of(possibleCommentString);
    }

    private static Optional<String> getSymbolDocumentationComments(SchemaNode node, String documentContent) {
        Optional<String> comment;
        int offset = node.getOriginalBeginOffset();
        if (offset == -1) {
            return Optional.empty();
        }
        int linePointer = documentContent.lastIndexOf("\n", offset);
        LinkedList<String> comments = new LinkedList<String>();
        while (linePointer != -1 && !(comment = SchemaHover.getCommentOnLine(documentContent, linePointer)).isEmpty()) {
            comments.add(0, comment.get());
            linePointer = documentContent.lastIndexOf("\n", linePointer - 1);
        }
        if (comments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)"\n", comments));
    }

    private static Hover getStructHover(SchemaNode node, EventPositionContext context) {
        Optional<Symbol> structDefinitionSymbol = context.schemaIndex.getSymbolDefinition(node.getSymbol());
        if (structDefinitionSymbol.isEmpty()) {
            return null;
        }
        List<Symbol> fieldDefs = context.schemaIndex.listSymbolsInScope(structDefinitionSymbol.get(), Symbol.SymbolType.FIELD);
        Object result = "### struct " + structDefinitionSymbol.get().getShortIdentifier() + "\n";
        for (Symbol fieldDef : fieldDefs) {
            result = (String)result + "    field " + fieldDef.getShortIdentifier() + " type " + fieldDef.getNode().getNextSibling().getNextSibling().getText();
            if (!fieldDef.isInScope(structDefinitionSymbol.get())) {
                result = (String)result + " (inherited from " + fieldDef.getScope().getPrettyIdentifier() + ")";
            }
            result = (String)result + "\n";
        }
        if (((String)result).isEmpty()) {
            result = "no fields found";
        }
        return new Hover(new MarkupContent("markdown", (String)result));
    }

    private static Hover getFieldHover(SchemaNode node, EventPositionContext context) {
        Optional<Symbol> fieldDefinitionSymbol = context.schemaIndex.getSymbolDefinition(node.getSymbol());
        if (fieldDefinitionSymbol.isEmpty()) {
            return null;
        }
        Optional<SchemaNode> dataTypeNode = context.schemaIndex.fieldIndex().getFieldDataTypeNode(fieldDefinitionSymbol.get());
        String typeText = "unknown";
        if (dataTypeNode.isPresent()) {
            typeText = dataTypeNode.get().getText().trim();
        }
        Object fieldIdentifier = fieldDefinitionSymbol.get().getShortIdentifier();
        for (Symbol scopeIterator = fieldDefinitionSymbol.get().getScope(); scopeIterator != null && scopeIterator.getType() == Symbol.SymbolType.FIELD; scopeIterator = scopeIterator.getScope()) {
            fieldIdentifier = scopeIterator.getShortIdentifier() + "." + (String)fieldIdentifier;
        }
        String hoverText = "field " + (String)fieldIdentifier + " type " + typeText;
        hoverText = context.schemaIndex.fieldIndex().getIsInsideDoc(fieldDefinitionSymbol.get()) ? (fieldDefinitionSymbol.get().getScope() != null && fieldDefinitionSymbol.get().getScope().getType() == Symbol.SymbolType.STRUCT ? hoverText + " (in struct " + fieldDefinitionSymbol.get().getScope().getShortIdentifier() + ")" : hoverText + " (in document)") : hoverText + " (outside document)";
        Object[] indexingTypes = context.schemaIndex.fieldIndex().getFieldIndexingTypes(fieldDefinitionSymbol.get()).toArray();
        for (int i = 0; i < indexingTypes.length; ++i) {
            hoverText = i == 0 ? hoverText + "\n\t" : hoverText + " | ";
            hoverText = hoverText + indexingTypes[i].toString().toLowerCase();
        }
        String fieldDefinitionDocumentContent = context.scheduler.getDocument(fieldDefinitionSymbol.get().getFileURI()).getCurrentContent();
        Optional<String> documentationComments = SchemaHover.getSymbolDocumentationComments(fieldDefinitionSymbol.get().getNode(), fieldDefinitionDocumentContent);
        if (documentationComments.isPresent()) {
            hoverText = documentationComments.get() + "\n" + hoverText;
        }
        return new Hover(new MarkupContent("markdown", "```\n" + hoverText + "\n```"));
    }

    private static Hover getSymbolHover(SchemaNode node, EventPositionContext context) {
        SchemaNode definitionNode;
        Optional<Symbol> definition;
        switch (node.getSymbol().getType()) {
            case STRUCT: {
                return SchemaHover.getStructHover(node, context);
            }
            case FIELD: {
                return SchemaHover.getFieldHover(node, context);
            }
        }
        if (node.getSymbol().getType() == Symbol.SymbolType.LABEL) {
            return new Hover(new MarkupContent("plaintext", "label"));
        }
        if (node.getSymbol().getStatus() == Symbol.SymbolStatus.BUILTIN_REFERENCE) {
            return new Hover(new MarkupContent("plaintext", "builtin"));
        }
        if ((node.getSymbol().getStatus() == Symbol.SymbolStatus.REFERENCE || node.getSymbol().getStatus() == Symbol.SymbolStatus.DEFINITION) && (definition = context.schemaIndex.getSymbolDefinition(node.getSymbol())).isPresent() && (definitionNode = definition.get().getNode()).getParent() != null) {
            String text = definitionNode.getParent().getText();
            String[] lines = text.split(System.lineSeparator());
            Object hoverContent = lines[0].trim();
            while (((String)hoverContent).length() > 0 && ((String)hoverContent).endsWith("{")) {
                hoverContent = ((String)hoverContent).substring(0, ((String)hoverContent).length() - 1);
            }
            hoverContent = ((String)hoverContent).trim();
            String documentContent = context.scheduler.getDocument(definition.get().getFileURI()).getCurrentContent();
            Optional<String> documentationComments = SchemaHover.getSymbolDocumentationComments(definitionNode, documentContent);
            if (documentationComments.isPresent()) {
                hoverContent = documentationComments.get() + "\n" + (String)hoverContent;
            }
            if (((String)hoverContent).length() > 0) {
                return new Hover(new MarkupContent("markdown", "```\n" + (String)hoverContent + "\n```"));
            }
        }
        return null;
    }

    private static Hover getIndexingHover(SchemaNode hoverNode, EventPositionContext context) {
        if (hoverNode.isASTInstance(ATTRIBUTE.class)) {
            return new Hover(new MarkupContent("markdown", "## Attribute\nAttribute is used to make a field available for sorting, grouping, ranking and searching using match mode `word`.\n"));
        }
        if (hoverNode.isASTInstance(INDEX.class)) {
            return new Hover(new MarkupContent("markdown", "## Index\nCreates a searchable index for the values of this field using match mode `text`. All strings are lower-cased before stored in the index. By default, the index name will be the same as the name of the schema field. Use a fieldset to combine fields in the same set for searching.\n"));
        }
        if (hoverNode.isASTInstance(SUMMARY.class)) {
            return new Hover(new MarkupContent("markdown", "## Summary\nIncludes the value of this field in a summary field. Summary fields of type string are limited to 64 kB. If a larger string is stored, the indexer will issue a warning and truncate the value to 64 kB. Modify summary output by using `summary:` in the field body (e.g. to generate dynamic teasers).\n"));
        }
        return null;
    }

    private static Optional<Hover> rankFeatureHover(SchemaNode node, EventPositionContext context) {
        SchemaNode currentNode = node;
        while (currentNode.getLanguageType() == SchemaNode.LanguageType.RANK_EXPRESSION && currentNode.getRankNode().isEmpty()) {
            currentNode = currentNode.getParent();
        }
        if (currentNode.getRankNode().isEmpty()) {
            return Optional.empty();
        }
        RankNode rankNode = currentNode.getRankNode().get();
        Optional<SpecificFunction> rankNodeSignature = rankNode.getFunctionSignature();
        if (rankNodeSignature.isEmpty()) {
            return Optional.empty();
        }
        SpecificFunction functionSignature = rankNodeSignature.get().clone();
        if (node.hasSymbol() && node.getSymbol().getType() != Symbol.SymbolType.PROPERTY) {
            functionSignature.clearProperty();
        }
        Optional<Hover> result = SchemaHover.getRankFeatureHover(functionSignature);
        result.ifPresent(hover -> hover.setRange(node.getRange()));
        return result;
    }

    public static Optional<Hover> getRankFeatureHover(SpecificFunction function2) {
        Optional<Hover> result = SchemaHover.getFileHoverInformation("rankExpression/" + function2.getSignatureString(), new Range());
        if (result.isPresent()) {
            return result;
        }
        return SchemaHover.getFileHoverInformation("rankExpression/" + function2.getSignatureString(true), new Range());
    }

    public static Hover getHover(EventPositionContext context) {
        SchemaNode node = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (node != null) {
            Optional<Hover> builtinHover;
            MarkupContent markupContent;
            Either content;
            Hover symbolHover = SchemaHover.getSymbolHover(node, context);
            if (node.getLanguageType() == SchemaNode.LanguageType.RANK_EXPRESSION && (content = symbolHover.getContents()).isRight() && (markupContent = (MarkupContent)content.getRight()).getValue() == "builtin" && (builtinHover = SchemaHover.rankFeatureHover(node, context)).isPresent()) {
                return builtinHover.get();
            }
            return symbolHover;
        }
        node = CSTUtils.getLeafNodeAtPosition(context.document.getRootNode(), context.position);
        if (node == null) {
            return null;
        }
        if (node.getLanguageType() == SchemaNode.LanguageType.INDEXING) {
            return SchemaHover.getIndexingHover(node, context);
        }
        Optional<Hover> hoverInfo = SchemaHover.getFileHoverInformation("schema/" + node.getClassLeafIdentifierString(), node.getRange());
        if (hoverInfo.isEmpty()) {
            return null;
        }
        return hoverInfo.get();
    }

    public static Optional<Hover> getFileHoverInformation(String markdownKey, Range range) {
        Optional<MarkupContent> mdContent;
        if (markdownContentCache.containsKey(markdownKey) && (mdContent = markdownContentCache.get(markdownKey)) != null) {
            if (mdContent.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Hover(mdContent.get(), range));
        }
        String fileName = markdownPathRoot + markdownKey + ".md";
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (inputStream == null) {
            markdownContentCache.put(markdownKey, Optional.empty());
            return Optional.empty();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String markdown = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        MarkupContent mdContent2 = new MarkupContent("markdown", markdown);
        Hover hover = new Hover(mdContent2, range);
        markdownContentCache.put(markdownKey, Optional.of(mdContent2));
        return Optional.of(hover);
    }
}

