/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.codeaction.provider;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.common.StringUtils;
import ai.vespa.schemals.context.EventCodeActionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.codeaction.provider.CodeActionProvider;
import ai.vespa.schemals.lsp.codeaction.utils.CodeActionUtils;
import ai.vespa.schemals.lsp.rename.SchemaRename;
import ai.vespa.schemals.parser.ast.attributeElm;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.parser.ast.indexInsideField;
import ai.vespa.schemals.parser.ast.inheritsDocument;
import ai.vespa.schemals.parser.ast.inheritsRankProfile;
import ai.vespa.schemals.parser.ast.openLbrace;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.parser.ast.rootSchemaItem;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class QuickFixProvider
implements CodeActionProvider {
    private CodeAction basicQuickFix(String title, Diagnostic fixFor) {
        CodeAction action = new CodeAction();
        action.setTitle(title);
        action.setKind("quickfix");
        action.setDiagnostics(List.of(fixFor));
        return action;
    }

    private CodeAction fixSchemaNameSameAsFile(EventCodeActionContext context, Diagnostic diagnostic) {
        String requiredName = FileUtils.schemaNameFromPath(context.document.getFileURI());
        CodeAction action = this.basicQuickFix("Rename schema to " + requiredName, diagnostic);
        action.setEdit(SchemaRename.rename(context, requiredName));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private CodeAction fixDocumentNameSameAsSchema(EventCodeActionContext context, Diagnostic diagnostic) {
        if (!(context.document instanceof SchemaDocument)) {
            return null;
        }
        SchemaDocument document = (SchemaDocument)context.document;
        if (document.getSchemaIdentifier() == null) {
            return null;
        }
        CodeAction action = this.basicQuickFix("Rename document to " + document.getSchemaIdentifier(), diagnostic);
        action.setEdit(CodeActionUtils.simpleEdit(context, diagnostic.getRange(), document.getSchemaIdentifier()));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private Position firstPositionInBlock(SchemaNode blockNode) {
        for (SchemaNode child : blockNode) {
            if (!child.isASTInstance(openLbrace.class)) continue;
            return child.get(0).getRange().getEnd();
        }
        return null;
    }

    private SchemaNode findRootSchemaItemNode(SchemaNode start) {
        SchemaNode rootSchemaItemNode;
        for (rootSchemaItemNode = start; rootSchemaItemNode != null && !rootSchemaItemNode.isASTInstance(rootSchemaItem.class); rootSchemaItemNode = rootSchemaItemNode.getParent()) {
        }
        return rootSchemaItemNode;
    }

    private CodeAction fixAccessUnimportedField(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode offendingNode = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (offendingNode == null) {
            return null;
        }
        SchemaNode referenceFieldNode = offendingNode.getPreviousSibling();
        if (referenceFieldNode == null) {
            return null;
        }
        if (!referenceFieldNode.hasSymbol()) {
            return null;
        }
        String newFieldName = referenceFieldNode.getSymbol().getShortIdentifier() + "_" + offendingNode.getSymbol().getShortIdentifier();
        SchemaNode rootSchemaItemNode = this.findRootSchemaItemNode(offendingNode);
        if (rootSchemaItemNode == null) {
            return null;
        }
        Position insertPosition = rootSchemaItemNode.getRange().getEnd();
        String indentString = StringUtils.getIndentString(context.document.getCurrentContent(), rootSchemaItemNode);
        int indent = StringUtils.countSpaceIndents(indentString);
        if (rootSchemaItemNode.getPreviousSibling() != null) {
            insertPosition = rootSchemaItemNode.getPreviousSibling().getRange().getEnd();
        }
        CodeAction action = this.basicQuickFix("Import field " + offendingNode.getSymbol().getShortIdentifier(), diagnostic);
        action.setEdit(CodeActionUtils.simpleEditList(context, List.of(new TextEdit(new Range(insertPosition, insertPosition), StringUtils.spaceIndent(indent) + "import field " + referenceFieldNode.getSymbol().getShortIdentifier() + "." + offendingNode.getSymbol().getShortIdentifier() + " as " + newFieldName + " {} \n\n"), new TextEdit(CSTUtils.unionRanges(offendingNode.getRange(), referenceFieldNode.getRange()), newFieldName))));
        return action;
    }

    private CodeAction fixDocumentlessSchema(EventCodeActionContext context, Diagnostic diagnostic) {
        if (!(context.document instanceof SchemaDocument)) {
            return null;
        }
        SchemaDocument document = (SchemaDocument)context.document;
        if (document.getSchemaIdentifier() == null) {
            return null;
        }
        String schemaName = document.getSchemaIdentifier();
        CodeAction action = this.basicQuickFix("Insert document definition '" + schemaName + "'", diagnostic);
        SchemaNode rootSchemaNode = document.getRootNode().get(0);
        Position insertPosition = this.firstPositionInBlock(rootSchemaNode);
        if (insertPosition == null) {
            insertPosition = CSTUtils.addPositions(diagnostic.getRange().getStart(), new Position(1, 0));
            insertPosition.setCharacter(0);
        }
        SchemaNode offendingNode = CSTUtils.getNodeAtPosition(context.document.getRootNode(), diagnostic.getRange().getStart());
        String indentString = StringUtils.getIndentString(context.document.getCurrentContent(), offendingNode);
        int indent = StringUtils.countSpaceIndents(indentString) + 4;
        action.setEdit(CodeActionUtils.simpleEditList(context, List.of(new TextEdit(new Range(insertPosition, insertPosition), "\n" + StringUtils.spaceIndent(indent) + "document " + schemaName + " {\n" + StringUtils.spaceIndent(indent + 4) + "\n" + StringUtils.spaceIndent(indent) + "}"))));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private CodeAction fixDocumentReferenceAttribute(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode fieldIdentifierNode = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (fieldIdentifierNode == null) {
            return null;
        }
        Position insertPosition = this.firstPositionInBlock(fieldIdentifierNode.getParent());
        if (insertPosition == null) {
            return null;
        }
        CodeAction action = this.basicQuickFix("Set indexing to 'attribute' for field " + fieldIdentifierNode.getSymbol().getShortIdentifier(), diagnostic);
        String indentString = StringUtils.getIndentString(context.document.getCurrentContent(), fieldIdentifierNode.getParent());
        int indent = StringUtils.countSpaceIndents(indentString);
        action.setEdit(CodeActionUtils.simpleEdit(context, new Range(insertPosition, insertPosition), "\n" + StringUtils.spaceIndent(indent + 4) + "indexing: attribute\n" + StringUtils.spaceIndent(indent)));
        return action;
    }

    private CodeAction fixImportFieldAttribute(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode importReferenceNode = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (importReferenceNode == null) {
            return null;
        }
        Symbol referenceSymbol = importReferenceNode.getSymbol();
        Optional<Symbol> definitionSymbol = context.schemaIndex.getSymbolDefinition(referenceSymbol);
        if (definitionSymbol.isEmpty()) {
            return null;
        }
        SchemaNode definitionFieldElm = definitionSymbol.get().getNode().getParent();
        DocumentManager definitionDocument = context.scheduler.getDocument(definitionSymbol.get().getFileURI());
        Position insertPosition = this.firstPositionInBlock(definitionFieldElm);
        CodeAction action = this.basicQuickFix("Set indexing to 'attribute' for field " + definitionSymbol.get().getLongIdentifier(), diagnostic);
        String indentString = StringUtils.getIndentString(definitionDocument.getCurrentContent(), definitionFieldElm);
        int indent = StringUtils.countSpaceIndents(indentString);
        action.setEdit(CodeActionUtils.simpleEdit(context, new Range(insertPosition, insertPosition), "\n" + StringUtils.spaceIndent(indent + 4) + "indexing: attribute\n" + StringUtils.spaceIndent(indent), definitionDocument));
        return action;
    }

    private CodeAction fixExplicitlyInheritDocument(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode offendingNode = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (offendingNode == null) {
            return null;
        }
        Symbol schemaReferenceSymbol = offendingNode.getSymbol();
        String mySchemaIdentifier = offendingNode.getParent().get(1).getText();
        Optional<Symbol> myDocumentDefinition = context.schemaIndex.findSymbol(null, Symbol.SymbolType.DOCUMENT, mySchemaIdentifier);
        if (myDocumentDefinition.isEmpty() || myDocumentDefinition.get().getType() != Symbol.SymbolType.DOCUMENT) {
            return null;
        }
        SchemaNode documentIdentifierNode = myDocumentDefinition.get().getNode();
        CodeAction action = this.basicQuickFix("Inherit document '" + schemaReferenceSymbol.getShortIdentifier() + "'", diagnostic);
        action.setEdit(CodeActionUtils.createInheritsEdit(context, documentIdentifierNode, inheritsDocument.class, schemaReferenceSymbol.getShortIdentifier()));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private CodeAction fixInheritsStructFieldRedeclared(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode offendingNode = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (offendingNode == null) {
            return null;
        }
        CodeAction action = this.basicQuickFix("Remove field declaration '" + offendingNode.getText() + "'", diagnostic);
        Range fieldRange = offendingNode.getParent().getRange();
        action.setEdit(CodeActionUtils.simpleEdit(context, fieldRange, ""));
        return action;
    }

    private CodeAction fixAnnotationReferenceOutsideAnnotation(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode fieldElmNode;
        SchemaNode offendingNode = CSTUtils.getNodeAtPosition(context.document.getRootNode(), context.position);
        if (offendingNode == null) {
            return null;
        }
        for (fieldElmNode = offendingNode; fieldElmNode != null && !fieldElmNode.isASTInstance(fieldElm.class); fieldElmNode = fieldElmNode.getParent()) {
        }
        if (fieldElmNode == null) {
            return null;
        }
        CodeAction action = this.basicQuickFix("Enclose field in annotation", diagnostic);
        String fieldBody = fieldElmNode.getText().replace("\n", "\n" + StringUtils.spaceIndent(4));
        String indentString = StringUtils.getIndentString(context.document.getCurrentContent(), fieldElmNode);
        int indent = StringUtils.countSpaceIndents(indentString);
        action.setEdit(CodeActionUtils.simpleEdit(context, fieldElmNode.getRange(), "annotation myannotation {\n" + StringUtils.spaceIndent(indent + 4) + fieldBody + "\n" + StringUtils.spaceIndent(indent) + "}"));
        return action;
    }

    private CodeAction fixDeprecatedArraySyntax(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode tokenNode = CSTUtils.getLeafNodeAtPosition(context.document.getRootNode(), context.position);
        if (tokenNode == null) {
            return null;
        }
        if (!tokenNode.getParent().getParent().isASTInstance(dataType.class)) {
            return null;
        }
        String typeText = tokenNode.getText();
        CodeAction action = this.basicQuickFix("Change to array<" + typeText + ">", diagnostic);
        action.setEdit(CodeActionUtils.simpleEdit(context, tokenNode.getParent().getParent().getRange(), "array<" + typeText + ">"));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private CodeAction fixDeprecatedTokenSearch(EventCodeActionContext context, Diagnostic diagnostic) {
        CodeAction action = this.basicQuickFix("Change to schema", diagnostic);
        action.setEdit(CodeActionUtils.simpleEdit(context, diagnostic.getRange(), "schema"));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private CodeAction fixDeprecatedTokenAttributeOrIndex(EventCodeActionContext context, Diagnostic diagnostic, SchemaDiagnostic.DiagnosticCode code) {
        SchemaNode offendingBodyElmNode;
        String replacementKind;
        Class offendingBodyClass;
        if (!context.document.getRootNode().get(0).isASTInstance(rootSchema.class)) {
            return null;
        }
        if (code == SchemaDiagnostic.DiagnosticCode.DEPRECATED_TOKEN_ATTRIBUTE) {
            offendingBodyClass = attributeElm.class;
            replacementKind = "attribute";
        } else {
            offendingBodyClass = indexInsideField.class;
            replacementKind = "index";
        }
        SchemaNode offendingNode = CSTUtils.getNodeAtPosition(context.document.getRootNode(), context.position);
        Optional<Symbol> fieldDefinition = CSTUtils.findScope(offendingNode);
        if (fieldDefinition.isEmpty()) {
            return null;
        }
        Optional<SchemaNode> dataTypeNode = context.schemaIndex.fieldIndex().getFieldDataTypeNode(fieldDefinition.get());
        String dataTypeString = dataTypeNode.isPresent() ? dataTypeNode.get().getText() : "string";
        for (offendingBodyElmNode = offendingNode; offendingBodyElmNode != null && !offendingBodyElmNode.isASTInstance(offendingBodyClass); offendingBodyElmNode = offendingBodyElmNode.getParent()) {
        }
        if (offendingBodyElmNode == null) {
            return null;
        }
        SchemaNode rootSchemaItemNode = this.findRootSchemaItemNode(offendingNode);
        if (rootSchemaItemNode == null) {
            return null;
        }
        String insertIndentString = StringUtils.getIndentString(context.document.getCurrentContent(), rootSchemaItemNode);
        int indent = StringUtils.countSpaceIndents(insertIndentString);
        Range insertPosition = new Range(rootSchemaItemNode.getRange().getEnd(), rootSchemaItemNode.getRange().getEnd());
        String offendingBodyIndentString = StringUtils.getIndentString(context.document.getCurrentContent(), offendingBodyElmNode);
        int bodyIndentDelta = indent + 4 - StringUtils.countSpaceIndents(offendingBodyIndentString);
        String offendingBodyText = StringUtils.addIndents(offendingBodyElmNode.getText().replace("\t", StringUtils.spaceIndent(4)), bodyIndentDelta);
        CodeAction action = this.basicQuickFix("Create field '" + offendingNode.getText() + "' outside document", diagnostic);
        action.setEdit(CodeActionUtils.simpleEditList(context, List.of(new TextEdit(offendingBodyElmNode.getRange(), ""), new TextEdit(insertPosition, "\n" + StringUtils.spaceIndent(indent) + "field " + offendingNode.getText() + " type " + dataTypeString + " {\n" + StringUtils.spaceIndent(indent + 4) + "# TODO: Auto-generated indexing statement\n" + StringUtils.spaceIndent(indent + 4) + "indexing: input " + fieldDefinition.get().getShortIdentifier() + " | " + replacementKind + "\n" + StringUtils.spaceIndent(indent + 4) + offendingBodyText + "\n" + StringUtils.spaceIndent(indent) + "}"))));
        action.setIsPreferred(Boolean.valueOf(true));
        return action;
    }

    private CodeAction fixFeaturesInheritsNonParent(EventCodeActionContext context, Diagnostic diagnostic) {
        SchemaNode offendingNode = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), context.position);
        if (offendingNode == null || offendingNode.getSymbol().getScope() == null) {
            return null;
        }
        Symbol rankProfileSymbol = offendingNode.getSymbol().getScope();
        CodeAction action = this.basicQuickFix("Inherit rank-profile " + offendingNode.getText() + " from " + rankProfileSymbol.getShortIdentifier(), diagnostic);
        action.setEdit(CodeActionUtils.createInheritsEdit(context, rankProfileSymbol.getNode(), inheritsRankProfile.class, offendingNode.getText()));
        return action;
    }

    @Override
    public List<Either<Command, CodeAction>> getActions(EventCodeActionContext context) {
        ArrayList<Either<Command, CodeAction>> result = new ArrayList<Either<Command, CodeAction>>();
        for (Diagnostic diagnostic : context.diagnostics) {
            if (diagnostic.getCode() == null || diagnostic.getCode().isLeft()) continue;
            SchemaDiagnostic.DiagnosticCode code = SchemaDiagnostic.codeFromInt((Integer)diagnostic.getCode().getRight());
            switch (code) {
                case SCHEMA_NAME_SAME_AS_FILE: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixSchemaNameSameAsFile(context, diagnostic)));
                    break;
                }
                case DOCUMENT_NAME_SAME_AS_SCHEMA: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixDocumentNameSameAsSchema(context, diagnostic)));
                    break;
                }
                case ACCESS_UNIMPORTED_FIELD: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixAccessUnimportedField(context, diagnostic)));
                    break;
                }
                case DOCUMENTLESS_SCHEMA: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixDocumentlessSchema(context, diagnostic)));
                    break;
                }
                case DOCUMENT_REFERENCE_ATTRIBUTE: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixDocumentReferenceAttribute(context, diagnostic)));
                    break;
                }
                case IMPORT_FIELD_ATTRIBUTE: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixImportFieldAttribute(context, diagnostic)));
                    break;
                }
                case EXPLICITLY_INHERIT_DOCUMENT: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixExplicitlyInheritDocument(context, diagnostic)));
                    break;
                }
                case INHERITS_STRUCT_FIELD_REDECLARED: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixInheritsStructFieldRedeclared(context, diagnostic)));
                    break;
                }
                case ANNOTATION_REFERENCE_OUTSIDE_ANNOTATION: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixAnnotationReferenceOutsideAnnotation(context, diagnostic)));
                    break;
                }
                case DEPRECATED_ARRAY_SYNTAX: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixDeprecatedArraySyntax(context, diagnostic)));
                    break;
                }
                case DEPRECATED_TOKEN_SEARCH: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixDeprecatedTokenSearch(context, diagnostic)));
                    break;
                }
                case DEPRECATED_TOKEN_ATTRIBUTE: 
                case DEPRECATED_TOKEN_INDEX: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixDeprecatedTokenAttributeOrIndex(context, diagnostic, code)));
                    break;
                }
                case FEATURES_INHERITS_NON_PARENT: {
                    result.add((Either<Command, CodeAction>)Either.forRight((Object)this.fixFeaturesInheritsNonParent(context, diagnostic)));
                    break;
                }
            }
        }
        return result;
    }
}

