/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.SchemaMessageHandler;
import ai.vespa.schemals.SchemaTextDocumentService;
import ai.vespa.schemals.SchemaWorkspaceService;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.lsp.command.CommandRegistry;
import ai.vespa.schemals.lsp.semantictokens.SchemaSemanticTokens;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class SchemaLanguageServer
implements LanguageServer,
LanguageClientAware {
    private WorkspaceService workspaceService;
    private SchemaTextDocumentService textDocumentService;
    private SchemaDocumentScheduler schemaDocumentScheduler;
    private SchemaIndex schemaIndex;
    private SchemaDiagnosticsHandler schemaDiagnosticsHandler;
    private SchemaMessageHandler schemaMessageHandler = new SchemaMessageHandler();
    private int errorCode = 1;
    private LanguageClient client;
    private ClientLogger logger = new ClientLogger(this.schemaMessageHandler);

    public static void main(String[] args2) {
        System.out.println("This function may be useful at one point");
    }

    public SchemaLanguageServer() {
        this.schemaIndex = new SchemaIndex(this.logger);
        this.schemaDiagnosticsHandler = new SchemaDiagnosticsHandler();
        this.schemaDocumentScheduler = new SchemaDocumentScheduler(this.logger, this.schemaDiagnosticsHandler, this.schemaIndex, this.schemaMessageHandler);
        this.textDocumentService = new SchemaTextDocumentService(this.logger, this.schemaDocumentScheduler, this.schemaIndex, this.schemaMessageHandler);
        this.workspaceService = new SchemaWorkspaceService(this.logger, this.schemaDocumentScheduler, this.schemaIndex, this.schemaMessageHandler);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams initializeParams) {
        InitializeResult initializeResult = new InitializeResult(new ServerCapabilities());
        this.schemaMessageHandler.setTraceValue(initializeParams.getTrace());
        initializeResult.getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        CompletionOptions completionOptions = new CompletionOptions();
        completionOptions.setTriggerCharacters(List.of("."));
        initializeResult.getCapabilities().setCompletionProvider(completionOptions);
        initializeResult.getCapabilities().setHoverProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setDefinitionProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setReferencesProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setRenameProvider(new RenameOptions(Boolean.valueOf(true)));
        initializeResult.getCapabilities().setSemanticTokensProvider(SchemaSemanticTokens.getSemanticTokensRegistrationOptions());
        initializeResult.getCapabilities().setDocumentSymbolProvider(Boolean.valueOf(true));
        initializeResult.getCapabilities().setExecuteCommandProvider(new ExecuteCommandOptions(CommandRegistry.getSupportedCommandList()));
        CodeActionOptions options = new CodeActionOptions(List.of("quickfix", "refactor", "refactor.rewrite"));
        initializeResult.getCapabilities().setCodeActionProvider(options);
        return CompletableFuture.supplyAsync(() -> initializeResult);
    }

    public void setTrace(SetTraceParams params) {
        this.schemaMessageHandler.setTraceValue(params.getValue());
    }

    public void initialized(InitializedParams params) {
    }

    public CompletableFuture<Object> shutdown() {
        this.errorCode = 0;
        return CompletableFutures.computeAsync(tmp -> {
            this.logger.info("Shutdown request received.");
            return null;
        });
    }

    public void exit() {
        System.exit(this.errorCode);
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public void connect(LanguageClient languageClient) {
        this.client = languageClient;
        this.schemaDiagnosticsHandler.connectClient(languageClient);
        this.schemaMessageHandler.connectClient(languageClient);
        this.client.logMessage(new MessageParams(MessageType.Log, "Language Server successfully connected to client."));
    }
}

