/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

public class Interval {
    public static final int INTERVAL_BEGIN = 1;
    public static final int MAX_INTERVAL_END = 65535;
    public static final int ZERO_CONSTRAINT_RANGE = 1;

    private Interval() {
    }

    public static int fromBoundaries(int begin, int end) {
        assert (begin >= 1 && begin <= 65535 && end >= 1 && end <= 65535) : Interval.toString(begin, end);
        return begin << 16 | end;
    }

    public static int fromZStar1Boundaries(int begin, int end) {
        assert (begin >= 0 && begin <= 65535 && end >= 1 && end <= 65535) : Interval.toString(end, begin);
        return end << 16 | begin;
    }

    public static int fromZStar2Boundaries(int end) {
        assert (end >= 1 && end <= 65535) : Interval.toString(0, end);
        return end;
    }

    public static boolean isZStar1Interval(int interval) {
        return Interval.getBegin(interval) > Interval.getEnd(interval);
    }

    public static boolean isZStar2Interval(int interval) {
        return (interval & 0xFFFF0000) == 0;
    }

    public static int getBegin(int interval) {
        return interval >>> 16;
    }

    public static int getEnd(int interval) {
        return interval & 0xFFFF;
    }

    public static int getZStar1Begin(int interval) {
        return Interval.getEnd(interval);
    }

    public static int getZStar1End(int interval) {
        return Interval.getBegin(interval);
    }

    public static int getZStar2End(int interval) {
        return interval;
    }

    public static int combineZStarIntervals(int zStar1, int zStar2) {
        return zStar1 >>> 16 | zStar2 << 16;
    }

    private static String toString(int begin, int end) {
        if (begin == 0) {
            return String.format("[%d]**", end);
        }
        if (begin > end) {
            return String.format("[%d, %d]*", begin, end);
        }
        return String.format("[%d, %d]", begin, end);
    }
}

