/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.google.common.collect.MinMaxPriorityQueue;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.tuple.primitive.ObjectLongPair;
import com.gs.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import com.yahoo.search.predicate.index.PostingList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CachedPostingListCounter {
    private static final double THRESHOLD_USE_BIT_VECTOR = 1.0;
    private final int nDocuments;
    private final ObjectLongHashMap<int[]> frequency = new ObjectLongHashMap();
    private final ObjectIntHashMap<int[]> postingListMapping;
    private final int[] bitVector;

    public CachedPostingListCounter(int nDocuments) {
        this.nDocuments = nDocuments;
        this.postingListMapping = new ObjectIntHashMap();
        this.bitVector = new int[0];
    }

    private CachedPostingListCounter(ObjectIntHashMap<int[]> postingListMapping, int[] bitVector) {
        this.nDocuments = bitVector.length;
        this.postingListMapping = postingListMapping;
        this.bitVector = bitVector;
    }

    public synchronized void registerUsage(List<PostingList> postingLists) {
        for (PostingList postingList : postingLists) {
            this.frequency.updateValue((Object)postingList.getDocIds(), 0L, (LongToLongFunction & Serializable)v -> v + 1L);
        }
    }

    public void countPostingListsPerDocument(List<PostingList> postingLists, byte[] nPostingListsForDocument) {
        Arrays.fill(nPostingListsForDocument, (byte)0);
        ArrayList<int[]> nonCachedPostingLists = new ArrayList<int[]>(postingLists.size());
        ArrayList<int[]> cachedPostingLists = new ArrayList<int[]>(postingLists.size());
        long nDocumentsCachedPostingLists = 0L;
        int postingListBitmap = 0;
        for (PostingList postingList : postingLists) {
            int[] docIds = postingList.getDocIds();
            int index = this.postingListMapping.getIfAbsent((Object)docIds, -1);
            if (index >= 0) {
                cachedPostingLists.add(docIds);
                postingListBitmap |= 1 << index;
                nDocumentsCachedPostingLists += (long)docIds.length;
                continue;
            }
            nonCachedPostingLists.add(docIds);
        }
        if (postingListBitmap != 0) {
            if ((double)nDocumentsCachedPostingLists > (double)this.nDocuments * 1.0) {
                this.countUsingBitVector(nPostingListsForDocument, postingListBitmap);
            } else {
                nonCachedPostingLists.addAll(cachedPostingLists);
            }
        }
        if (!nonCachedPostingLists.isEmpty()) {
            CachedPostingListCounter.countUsingDocIdIteration(nPostingListsForDocument, nonCachedPostingLists);
        }
    }

    private void countUsingBitVector(byte[] nPostingListsForDocument, int postingListBitmap) {
        for (int docId = 0; docId < this.nDocuments; ++docId) {
            int n = docId;
            nPostingListsForDocument[n] = (byte)(nPostingListsForDocument[n] + Integer.bitCount(this.bitVector[docId] & postingListBitmap));
        }
    }

    private static void countUsingDocIdIteration(byte[] nPostingListsForDocument, List<int[]> nonCachedPostingLists) {
        Iterator<int[]> iterator = nonCachedPostingLists.iterator();
        while (iterator.hasNext()) {
            int[] docIds;
            int[] nArray = docIds = iterator.next();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int docId;
                int n2 = docId = nArray[i];
                nPostingListsForDocument[n2] = (byte)(nPostingListsForDocument[n2] + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPostingListCounter rebuildCache() {
        MinMaxPriorityQueue mostExpensive = MinMaxPriorityQueue.maximumSize((int)32).expectedSize(32).create();
        CachedPostingListCounter cachedPostingListCounter = this;
        synchronized (cachedPostingListCounter) {
            for (ObjectLongPair p : this.frequency.keyValuesView()) {
                mostExpensive.add((Object)new Entry((int[])p.getOne(), p.getTwo()));
            }
        }
        ObjectIntHashMap postingListMapping = new ObjectIntHashMap();
        int[] bitVector = new int[this.nDocuments];
        int length = mostExpensive.size();
        for (int i = 0; i < length; ++i) {
            Entry e = (Entry)mostExpensive.removeFirst();
            int[] docIds = e.docIds;
            postingListMapping.put((Object)docIds, i);
            int[] nArray = docIds;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int docId;
                int n2 = docId = nArray[j];
                bitVector[n2] = bitVector[n2] | 1 << i;
            }
        }
        return new CachedPostingListCounter((ObjectIntHashMap<int[]>)postingListMapping, bitVector);
    }

    int[] getBitVector() {
        return this.bitVector;
    }

    ObjectIntHashMap<int[]> getPostingListMapping() {
        return this.postingListMapping;
    }

    private static class Entry
    implements Comparable<Entry> {
        public final int[] docIds;
        public final double cost;

        private Entry(int[] docIds, long frequency) {
            this.docIds = docIds;
            this.cost = (double)docIds.length * (double)frequency;
            assert (this.cost > 0.0);
        }

        @Override
        public int compareTo(Entry o) {
            return -Double.compare(this.cost, o.cost);
        }
    }
}

