/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.PredicateValue;
import com.yahoo.document.predicate.RangeEdgePartition;
import com.yahoo.document.predicate.RangePartition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FeatureRange
extends PredicateValue {
    private String key;
    private Long from;
    private Long to;
    private final List<RangePartition> partitions;
    private final List<RangeEdgePartition> edgePartitions;

    public FeatureRange(String key) {
        this(key, null, null);
    }

    public FeatureRange(String key, Long fromInclusive, Long toInclusive) {
        this.setKey(key);
        this.setFromInclusive(fromInclusive);
        this.setToInclusive(toInclusive);
        this.partitions = new ArrayList<RangePartition>();
        this.edgePartitions = new ArrayList<RangeEdgePartition>();
    }

    public FeatureRange setKey(String key) {
        Objects.requireNonNull(key, "key");
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public FeatureRange setFromInclusive(Long from) {
        if (from != null && this.to != null && from > this.to) {
            throw new IllegalArgumentException("Expected 'from' less than or equal to " + this.to + ", got " + from + ".");
        }
        this.from = from;
        return this;
    }

    public Long getFromInclusive() {
        return this.from;
    }

    public FeatureRange setToInclusive(Long to) {
        if (this.from != null && to != null && this.from > to) {
            throw new IllegalArgumentException("Expected 'to' greater than or equal to " + this.from + ", got " + to + ".");
        }
        this.to = to;
        return this;
    }

    public Long getToInclusive() {
        return this.to;
    }

    public void addPartition(RangePartition p) {
        if (p instanceof RangeEdgePartition) {
            this.edgePartitions.add((RangeEdgePartition)p);
        } else {
            this.partitions.add(p);
        }
    }

    public List<RangeEdgePartition> getEdgePartitions() {
        return this.edgePartitions;
    }

    public List<RangePartition> getPartitions() {
        return this.partitions;
    }

    public void clearPartitions() {
        this.partitions.clear();
        this.edgePartitions.clear();
    }

    @Override
    public FeatureRange clone() throws CloneNotSupportedException {
        return (FeatureRange)super.clone();
    }

    public int hashCode() {
        return ((this.key.hashCode() + (this.from != null ? this.from.hashCode() : 0)) * 31 + (this.to != null ? this.to.hashCode() : 0)) * 31;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FeatureRange)) {
            return false;
        }
        FeatureRange rhs = (FeatureRange)obj;
        if (!this.key.equals(rhs.key)) {
            return false;
        }
        if (!Objects.equals(this.from, rhs.from)) {
            return false;
        }
        if (!Objects.equals(this.to, rhs.to)) {
            return false;
        }
        return this.partitions.equals(rhs.partitions) && this.edgePartitions.equals(rhs.edgePartitions);
    }

    @Override
    protected void appendTo(StringBuilder out) {
        FeatureRange.appendQuotedTo(this.key, out);
        out.append(" in [");
        if (this.from != null) {
            out.append(this.from);
        }
        out.append("..");
        if (this.to != null) {
            out.append(this.to);
        }
        if (!this.partitions.isEmpty() || !this.edgePartitions.isEmpty()) {
            out.append(" (");
            for (RangeEdgePartition rangeEdgePartition : this.edgePartitions) {
                rangeEdgePartition.appendTo(out);
                out.append(',');
            }
            for (RangePartition rangePartition : this.partitions) {
                rangePartition.appendTo(out);
                out.append(',');
            }
            out.deleteCharAt(out.length() - 1);
            out.append(")");
        }
        out.append("]");
    }

    public static FeatureRange buildFromMixedIn(String key, List<String> partitions, int arity) {
        Long fromInclusive = null;
        Long toInclusive = null;
        long from = 0L;
        long to = 0L;
        for (String p : partitions) {
            String[] parts = p.split(",");
            if (parts.length == 1) {
                int offset;
                String[] subparts = parts[0].split("=|-");
                int n = offset = subparts.length == 3 ? 0 : 1;
                if (subparts.length < 3 || subparts.length > 4) {
                    throw new IllegalArgumentException("MIXED_IN range partition must be on the form label=val-val");
                }
                from = Long.parseLong(subparts[offset + 1]);
                to = Long.parseLong(subparts[offset + 2]);
                if (parts[0].contains("=-")) {
                    long tmp = from;
                    from = -to;
                    to = -tmp;
                }
            } else {
                if (parts.length != 3) {
                    throw new IllegalArgumentException("MIXED_IN range edge partition must be on the form label=val,val,payload");
                }
                long value = Long.parseLong(parts[1]);
                long payload = Long.parseLong(parts[2]);
                if ((payload & 0xFFFFFFFFC0000000L) == 0x80000000L) {
                    from = value + (payload & 0xFFFFL);
                    to = value + (long)arity - 1L;
                } else if ((payload & 0xFFFFFFFFC0000000L) == 0x40000000L) {
                    from = value;
                    to = value + (payload & 0xFFFFL);
                } else {
                    from = value + (payload >> 16);
                    to = value + (payload & 0xFFFFL);
                }
            }
            if (fromInclusive == null || fromInclusive > from) {
                fromInclusive = from;
            }
            if (toInclusive != null && toInclusive <= to) continue;
            toInclusive = to;
        }
        return new FeatureRange(key, fromInclusive, toInclusive);
    }
}

