/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.RangePartition;

public class RangeEdgePartition
extends RangePartition {
    private final long value;
    private final int lowerBound;
    private final int upperBound;

    public RangeEdgePartition(String label, long value, int lower, int upper) {
        super(label);
        this.value = value;
        this.lowerBound = lower;
        this.upperBound = upper;
    }

    public long getValue() {
        return this.value;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public RangeEdgePartition clone() throws CloneNotSupportedException {
        return (RangeEdgePartition)super.clone();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Long.valueOf(this.value).hashCode() + Integer.valueOf(this.lowerBound).hashCode() + Integer.valueOf(this.upperBound).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RangeEdgePartition)) {
            return false;
        }
        RangeEdgePartition other = (RangeEdgePartition)obj;
        return super.equals(other) && this.value == other.value && this.lowerBound == other.lowerBound && this.upperBound == other.upperBound;
    }

    @Override
    protected void appendTo(StringBuilder out) {
        super.appendTo(out);
        out.append("+[");
        if (this.lowerBound > 0) {
            out.append(this.lowerBound);
        }
        out.append("..");
        if (this.upperBound >= 0) {
            out.append(this.upperBound);
        }
        out.append(']');
    }

    public long encodeBounds() {
        if (this.lowerBound > 0) {
            if (this.upperBound >= 0) {
                return this.lowerBound << 16 | this.upperBound + 1;
            }
            return (long)this.lowerBound | 0x80000000L;
        }
        if (this.upperBound >= 0) {
            return this.upperBound + 1 | 0x40000000;
        }
        return 0x80000000L;
    }
}

