/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.BooleanPredicate;
import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureRange;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateHash;
import com.yahoo.document.predicate.RangeEdgePartition;
import com.yahoo.document.predicate.RangePartition;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import java.util.Objects;

public class BinaryFormat {
    static final String NODE_TYPE = "type";
    static final String KEY = "key";
    static final String SET = "feature_set";
    static final String RANGE_MIN = "range_min";
    static final String RANGE_MAX = "range_max";
    static final String CHILDREN = "children";
    static final String PARTITIONS = "partitions";
    static final String EDGE_PARTITIONS = "edge_partitions";
    static final String HASHED_PARTITIONS = "hashed_partitions";
    static final String HASHED_EDGE_PARTITIONS = "hashed_edge_partitions";
    static final String HASH = "hash";
    static final String PAYLOAD = "payload";
    static final String LABEL = "label";
    static final String VALUE = "value";
    static final String LOWER_BOUND = "lower_bound";
    static final String UPPER_BOUND = "upper_bound";
    static final int TYPE_CONJUNCTION = 1;
    static final int TYPE_DISJUNCTION = 2;
    static final int TYPE_NEGATION = 3;
    static final int TYPE_FEATURE_SET = 4;
    static final int TYPE_FEATURE_RANGE = 5;
    static final int TYPE_TRUE = 6;
    static final int TYPE_FALSE = 7;

    public static byte[] encode(Predicate predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Slime slime = new Slime();
        BinaryFormat.encode(predicate, slime.setObject());
        return com.yahoo.slime.BinaryFormat.encode((Slime)slime);
    }

    public static Predicate decode(byte[] buf) {
        Objects.requireNonNull(buf, "buf");
        Slime slime = com.yahoo.slime.BinaryFormat.decode((byte[])buf);
        return BinaryFormat.decode((Inspector)slime.get());
    }

    private static Predicate decode(Inspector in) {
        switch ((int)in.field(NODE_TYPE).asLong()) {
            case 1: {
                Conjunction conjunction = new Conjunction(new Predicate[0]);
                in = in.field(CHILDREN);
                int len = in.children();
                for (int i = 0; i < len; ++i) {
                    conjunction.addOperand(BinaryFormat.decode(in.entry(i)));
                }
                return conjunction;
            }
            case 2: {
                Disjunction disjunction = new Disjunction(new Predicate[0]);
                in = in.field(CHILDREN);
                int len = in.children();
                for (int i = 0; i < len; ++i) {
                    disjunction.addOperand(BinaryFormat.decode(in.entry(i)));
                }
                return disjunction;
            }
            case 3: {
                return new Negation(BinaryFormat.decode(in.field(CHILDREN).entry(0)));
            }
            case 5: {
                int i;
                FeatureRange featureRange = new FeatureRange(in.field(KEY).asString());
                if (in.field(RANGE_MIN).valid()) {
                    featureRange.setFromInclusive(in.field(RANGE_MIN).asLong());
                }
                if (in.field(RANGE_MAX).valid()) {
                    featureRange.setToInclusive(in.field(RANGE_MAX).asLong());
                }
                Inspector p_in = in.field(PARTITIONS);
                int len = p_in.children();
                for (i = 0; i < len; ++i) {
                    featureRange.addPartition(new RangePartition(p_in.entry(i).asString()));
                }
                p_in = in.field(EDGE_PARTITIONS);
                len = p_in.children();
                for (i = 0; i < len; ++i) {
                    Inspector obj = p_in.entry(i);
                    featureRange.addPartition(new RangeEdgePartition(obj.field(LABEL).asString(), obj.field(VALUE).asLong(), (int)obj.field(LOWER_BOUND).asLong(), (int)obj.field(UPPER_BOUND).asLong()));
                }
                return featureRange;
            }
            case 4: {
                FeatureSet featureSet = new FeatureSet(in.field(KEY).asString(), new String[0]);
                in = in.field(SET);
                int len = in.children();
                for (int i = 0; i < len; ++i) {
                    featureSet.addValue(in.entry(i).asString());
                }
                return featureSet;
            }
            case 6: {
                return new BooleanPredicate(true);
            }
            case 7: {
                return new BooleanPredicate(false);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(in.field(NODE_TYPE).asLong()));
    }

    private static void encode(Predicate predicate, Cursor out) {
        if (predicate instanceof Conjunction) {
            out.setLong(NODE_TYPE, 1L);
            out = out.setArray(CHILDREN);
            for (Predicate operand : ((Conjunction)predicate).getOperands()) {
                BinaryFormat.encode(operand, out.addObject());
            }
        } else if (predicate instanceof Disjunction) {
            out.setLong(NODE_TYPE, 2L);
            out = out.setArray(CHILDREN);
            for (Predicate operand : ((Disjunction)predicate).getOperands()) {
                BinaryFormat.encode(operand, out.addObject());
            }
        } else if (predicate instanceof FeatureRange) {
            Long to;
            FeatureRange range = (FeatureRange)predicate;
            out.setLong(NODE_TYPE, 5L);
            out.setString(KEY, range.getKey());
            Long from = range.getFromInclusive();
            if (from != null) {
                out.setLong(RANGE_MIN, from.longValue());
            }
            if ((to = range.getToInclusive()) != null) {
                out.setLong(RANGE_MAX, to.longValue());
            }
            Cursor p_out = out.setArray(HASHED_PARTITIONS);
            for (RangePartition rangePartition : range.getPartitions()) {
                p_out.addLong(PredicateHash.hash64(rangePartition.getLabel()));
            }
            p_out = out.setArray(HASHED_EDGE_PARTITIONS);
            for (RangeEdgePartition rangeEdgePartition : range.getEdgePartitions()) {
                Cursor obj = p_out.addObject();
                obj.setLong(HASH, PredicateHash.hash64(rangeEdgePartition.getLabel()));
                obj.setLong(VALUE, rangeEdgePartition.getValue());
                obj.setLong(PAYLOAD, rangeEdgePartition.encodeBounds());
            }
        } else if (predicate instanceof FeatureSet) {
            out.setLong(NODE_TYPE, 4L);
            out.setString(KEY, ((FeatureSet)predicate).getKey());
            out = out.setArray(SET);
            for (String value : ((FeatureSet)predicate).getValues()) {
                out.addString(value);
            }
        } else if (predicate instanceof Negation) {
            out.setLong(NODE_TYPE, 3L);
            out = out.setArray(CHILDREN);
            BinaryFormat.encode(((Negation)predicate).getOperand(), out.addObject());
        } else if (predicate instanceof BooleanPredicate) {
            out.setLong(NODE_TYPE, ((BooleanPredicate)predicate).getValue() ? 6L : 7L);
        } else {
            throw new UnsupportedOperationException(predicate.getClass().getName());
        }
    }
}

