/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateOperator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FeatureConjunction
extends PredicateOperator {
    private final List<Predicate> operands;

    public FeatureConjunction(List<Predicate> operands) {
        FeatureConjunction.validateOperands(operands);
        this.operands = new ArrayList<Predicate>(operands);
    }

    private static void validateOperands(List<Predicate> operands) {
        if (operands.size() <= 1) {
            throw new IllegalArgumentException("Number of operands must 2 or more, was: " + operands.size());
        }
        if (!operands.stream().allMatch(FeatureConjunction::isValidFeatureConjunctionOperand)) {
            throw new IllegalArgumentException("A FeatureConjunction may only contain instances of Negation and FeatureSet, and a FeatureSet may only have one value.");
        }
        long uniqueKeys = operands.stream().map(FeatureConjunction::getFeatureSetKey).distinct().count();
        if ((long)operands.size() > uniqueKeys) {
            throw new IllegalArgumentException("Each FeatureSet key must have a unique key.");
        }
    }

    private static String getFeatureSetKey(Predicate predicate) {
        if (predicate instanceof FeatureSet) {
            return ((FeatureSet)predicate).getKey();
        }
        Negation negation = (Negation)predicate;
        return ((FeatureSet)negation.getOperand()).getKey();
    }

    public static boolean isValidFeatureConjunctionOperand(Predicate operand) {
        return operand instanceof Negation && ((Negation)operand).getOperand() instanceof FeatureSet && FeatureConjunction.isValidFeatureConjunctionOperand(((Negation)operand).getOperand()) || operand instanceof FeatureSet && ((FeatureSet)operand).getValues().size() == 1;
    }

    @Override
    public List<Predicate> getOperands() {
        return this.operands;
    }

    @Override
    protected void appendTo(StringBuilder out) {
        Iterator<Predicate> it = this.operands.iterator();
        while (it.hasNext()) {
            Predicate operand = it.next();
            if (operand instanceof Disjunction) {
                out.append('(');
                operand.appendTo(out);
                out.append(')');
            } else {
                operand.appendTo(out);
            }
            if (!it.hasNext()) continue;
            out.append(" conj ");
        }
    }

    @Override
    public FeatureConjunction clone() throws CloneNotSupportedException {
        return new FeatureConjunction(this.operands);
    }

    public int hashCode() {
        return this.operands.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FeatureConjunction)) {
            return false;
        }
        FeatureConjunction rhs = (FeatureConjunction)obj;
        return this.operands.equals(rhs.operands);
    }
}

