/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.xgboost;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.xgboost.XGBoostParser;
import ai.vespa.rankingexpression.importer.xgboost.XGBoostUbjParser;
import com.yahoo.io.IOUtils;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

public class XGBoostImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        if (modelFile.toString().endsWith(".ubj")) {
            return XGBoostUbjParser.probe(modelPath);
        }
        return modelFile.toString().endsWith(".json") && this.probe(modelFile);
    }

    private boolean probe(File modelFile) {
        try {
            String line;
            BufferedReader reader = IOUtils.createReader((String)modelFile.getAbsolutePath());
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("[")) {
                    return true;
                }
                if (line.isEmpty()) continue;
                return false;
            }
            return false;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + String.valueOf(modelFile) + "'", e);
        }
    }

    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try {
            ImportedModel model = new ImportedModel(modelName, modelPath, ImportedMlModel.ModelType.XGBOOST);
            if (modelPath.endsWith(".ubj")) {
                XGBoostUbjParser parser = new XGBoostUbjParser(modelPath);
                RankingExpression expression = new RankingExpression(parser.toRankingExpression());
                model.expression(modelName, expression);
            } else {
                XGBoostParser parser = new XGBoostParser(modelPath);
                RankingExpression expression = new RankingExpression(parser.toRankingExpression());
                model.expression(modelName, expression);
            }
            return model;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import XGBoost model from '" + modelPath + "'", e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse ranking expression resulting from '" + modelPath + "'", e);
        }
    }
}

