/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import ai.vespa.modelintegration.evaluator.EmbeddedOnnxRuntime;
import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import ai.vespa.modelintegration.evaluator.OnnxEvaluatorOptions;
import ai.vespa.triton.TritonOnnxRuntime;
import java.util.logging.Logger;

public interface OnnxRuntime {
    public static OnnxRuntime testInstance() {
        Logger log = Logger.getLogger(OnnxRuntime.class.getName());
        if (Boolean.getBoolean("VESPA_USE_TRITON")) {
            log.info("Using Triton ONNX runtime for testing");
            return TritonOnnxRuntime.createTestInstance();
        }
        log.info("Using embedded ONNX runtime for testing");
        return EmbeddedOnnxRuntime.createTestInstance();
    }

    public static boolean isRuntimeAvailable() {
        return EmbeddedOnnxRuntime.isRuntimeAvailable();
    }

    public static boolean isRuntimeAvailable(String modelPath) {
        return EmbeddedOnnxRuntime.isRuntimeAvailable(modelPath);
    }

    default public OnnxEvaluator evaluatorOf(String modelPath) {
        return this.evaluatorOf(modelPath, OnnxEvaluatorOptions.createDefault());
    }

    public OnnxEvaluator evaluatorOf(String var1, OnnxEvaluatorOptions var2);
}

