/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.OperationNode;
import com.yahoo.searchlib.rankingexpression.rule.Operator;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Matmul;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.text.ExpressionFormatter;
import java.util.List;
import java.util.Optional;

public class Gemm
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private final float alpha;
    private final float beta;
    private final int transposeA;
    private final int transposeB;
    private static final DoubleValue zero = DoubleValue.frozen((double)0.0);
    private static final DoubleValue one = DoubleValue.frozen((double)1.0);

    public Gemm(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        this.alpha = (float)attributeMap.get("alpha").orElse((Value)one).asDouble();
        this.beta = (float)attributeMap.get("beta").orElse((Value)one).asDouble();
        this.transposeA = (int)attributeMap.get("transA").orElse((Value)zero).asDouble();
        this.transposeB = (int)attributeMap.get("transB").orElse((Value)zero).asDouble();
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.check2or3InputsPresent()) {
            return null;
        }
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        TensorType.Dimension dimA = ((IntermediateOperation)this.inputs.get(0)).type().get().dimensions().get(this.transposeA);
        TensorType.Dimension dimB = ((IntermediateOperation)this.inputs.get(1)).type().get().dimensions().get(1 - this.transposeB);
        typeBuilder.add(dimA);
        typeBuilder.add(dimB);
        OrderedTensorType result = typeBuilder.build();
        if (this.inputs.size() == 3) {
            List<TensorType.Dimension> cDimensions = ((IntermediateOperation)this.inputs.get(2)).type().get().dimensions();
            if (cDimensions.size() == 2) {
                TensorType.Dimension dimC0 = cDimensions.get(0);
                TensorType.Dimension dimC1 = cDimensions.get(1);
                if (!dimA.size().equals(dimC0.size()) && (Long)dimC0.size().get() != 1L) {
                    throw new IllegalArgumentException("GEMM: type of optional input C " + String.valueOf(((IntermediateOperation)this.inputs.get(2)).type().get()) + " is not compatible or not broadcastable to " + String.valueOf(result.type()));
                }
                if (!dimB.size().equals(dimC1.size()) && (Long)dimC1.size().get() != 1L) {
                    throw new IllegalArgumentException("GEMM: type of optional input C " + String.valueOf(((IntermediateOperation)this.inputs.get(2)).type().get()) + " is not compatible or not broadcastable to " + String.valueOf(result.type()));
                }
            } else if (cDimensions.size() == 1) {
                TensorType.Dimension dimC0 = cDimensions.get(0);
                if (!dimB.size().equals(dimC0.size()) && (Long)dimC0.size().get() != 1L) {
                    throw new IllegalArgumentException("GEMM: type of optional input C " + String.valueOf(((IntermediateOperation)this.inputs.get(2)).type().get()) + " is not compatible or not broadcastable to " + String.valueOf(result.type()));
                }
            } else {
                throw new IllegalArgumentException("GEMM: optional input C has no dimensions.");
            }
        }
        return result;
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        if (!this.check2or3InputsPresent()) {
            return null;
        }
        OrderedTensorType aType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        OrderedTensorType bType = ((IntermediateOperation)this.inputs.get(1)).type().get();
        if (aType.type().rank() != 2 || bType.type().rank() != 2) {
            throw new IllegalArgumentException("Tensors in Gemm must have rank of exactly 2");
        }
        Optional<TensorFunction<Reference>> aFunction = ((IntermediateOperation)this.inputs.get(0)).function();
        Optional<TensorFunction<Reference>> bFunction = ((IntermediateOperation)this.inputs.get(1)).function();
        if (aFunction.isEmpty() || bFunction.isEmpty()) {
            return null;
        }
        String joinDimension = aType.dimensions().get(1 - this.transposeA).name();
        Matmul AxB = new Matmul(aFunction.get(), bFunction.get(), joinDimension);
        TensorFunctionNode.ExpressionTensorFunction alphaxAxB = new TensorFunctionNode.ExpressionTensorFunction((ExpressionNode)new OperationNode((ExpressionNode)new TensorFunctionNode((TensorFunction)AxB), Operator.multiply, (ExpressionNode)new ConstantNode((Value)new DoubleValue((double)this.alpha))));
        if (this.inputs.size() == 3) {
            Optional<TensorFunction<Reference>> cFunction = ((IntermediateOperation)this.inputs.get(2)).function();
            TensorFunctionNode.ExpressionTensorFunction betaxC = new TensorFunctionNode.ExpressionTensorFunction((ExpressionNode)new OperationNode((ExpressionNode)new TensorFunctionNode(cFunction.get()), Operator.multiply, (ExpressionNode)new ConstantNode((Value)new DoubleValue((double)this.beta))));
            return new Join((TensorFunction)alphaxAxB, (TensorFunction)betaxC, ScalarFunctions.add());
        }
        return alphaxAxB;
    }

    private boolean check2or3InputsPresent() {
        if (this.inputs.size() != 2 && this.inputs.size() != 3) {
            throw new IllegalArgumentException("Expected 2 or 3 inputs for '" + this.name + "', got " + this.inputs.size());
        }
        return this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.check2or3InputsPresent()) {
            return;
        }
        List<TensorType.Dimension> aDimensions = ((IntermediateOperation)this.inputs.get(0)).type().get().dimensions();
        List<TensorType.Dimension> bDimensions = ((IntermediateOperation)this.inputs.get(1)).type().get().dimensions();
        this.assertTwoDimensions(aDimensions, (IntermediateOperation)this.inputs.get(0), "first argument");
        this.assertTwoDimensions(bDimensions, (IntermediateOperation)this.inputs.get(1), "second argument");
        String aDim0 = aDimensions.get(this.transposeA).name();
        String aDim1 = aDimensions.get(1 - this.transposeA).name();
        String bDim0 = bDimensions.get(this.transposeB).name();
        String bDim1 = bDimensions.get(1 - this.transposeB).name();
        renamer.addConstraint(aDim1, bDim0, DimensionRenamer.Constraint.equal(false), this);
        renamer.addConstraint(aDim0, bDim1, DimensionRenamer.Constraint.lessThan(false), this);
        if (this.inputs.size() == 3) {
            List<TensorType.Dimension> cDimensions = ((IntermediateOperation)this.inputs.get(2)).type().get().dimensions();
            if (cDimensions.size() == 2) {
                String cDim0 = cDimensions.get(0).name();
                String cDim1 = cDimensions.get(1).name();
                renamer.addConstraint(aDim0, cDim0, DimensionRenamer.Constraint.equal(false), this);
                renamer.addConstraint(bDim1, cDim1, DimensionRenamer.Constraint.equal(false), this);
            } else if (cDimensions.size() == 1) {
                String cDim0 = cDimensions.get(0).name();
                renamer.addConstraint(bDim1, cDim0, DimensionRenamer.Constraint.equal(false), this);
            }
        }
        renamer.addConstraint(aDim0, aDim1, DimensionRenamer.Constraint.lessThan(true), this);
        renamer.addConstraint(bDim0, bDim1, DimensionRenamer.Constraint.greaterThan(true), this);
    }

    private void assertTwoDimensions(List<TensorType.Dimension> dimensions, IntermediateOperation supplier, String inputDescription) {
        if (dimensions.size() >= 2) {
            return;
        }
        throw new IllegalArgumentException("Expected 2 dimensions in the " + inputDescription + " to " + String.valueOf(this) + " but got just " + String.valueOf(dimensions) + " from\n" + ExpressionFormatter.inTwoColumnMode((int)70, (int)50).format(supplier.toFullString()));
    }

    @Override
    public Gemm withInputs(List<IntermediateOperation> inputs) {
        return new Gemm(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    @Override
    public String operationName() {
        return "Gemm";
    }
}

